//
//  MainMenu.cpp
//  menuSystem
//
//  Created by BradDSmith on 2013-02-26.
//  Copyright (c) 2013 BradDSmith. All rights reserved.
//

#include "MainMenu.h"

#include "console.h"

MainMenu::MainMenu()
{
    highlightedItem = 0;
    maxitems = MAXITEMS;
}

void MainMenu::setMaxItems(int max)
{
    maxitems = max;
}

void MainMenu::setMenuItem(int locID, int menuID, const char * menuText, int x, int y)
{
    if(locID <maxitems){
        menuItem[locID].initialize(menuID, (char *)menuText,x, y);
        }
}

void MainMenu::printMenu()
{
    for (int i = 0; i < maxitems; i++) {
        menuItem[i].print();
    }

   menuItem[highlightedItem].highlight();
}

void MainMenu::highlightNextItem()
{
    menuItem[highlightedItem].removeHighLight();
    
    highlightedItem++;
    if(highlightedItem >= maxitems)highlightedItem = 0;
    
    menuItem[highlightedItem].highlight();
}

void MainMenu::highlightPrevItem()
{
    menuItem[highlightedItem].removeHighLight();
    
    highlightedItem--;
    if(highlightedItem < 0)highlightedItem = maxitems - 1 ;
    
    menuItem[highlightedItem].highlight();
}

int MainMenu::getHighlightedItem()
{
    return menuItem[highlightedItem].getMenuID();
}

void MainMenu::erase()
{
       for (int i = 0; i < maxitems; i++) {
            menuItem[i].erase();
            }
}
