#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];


int RecordscreenPageHandler()
{
     int userSelection = 0;
     pageMenu[RECORDSCR].printMenu();

     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[RECORDSCR].erase();
                    printXY("                       ", 5, 10);    //erases the ACTION prompt
                    userSelection = HOME;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[RECORDSCR].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[RECORDSCR].highlightNextItem();
                    break;
                case 0x07:
                    userSelection = pageMenu[RECORDSCR].getHighlightedItem() ;
                    break;
                }//eo select

                // is the user selection an ACTION  assigned to this page
                if (userSelection != 0 && userSelection > RECORDSCROFFSET)  //page selections are 0 through 12
                    {
                    // place code here to handle actions processed directly from this page
                    
                    // TODO ask Brad about this section ******************---------------------*************
                    switch(userSelection)
                        {
                    
                        case EX_PLAYTRACK :
                            printXY("Example Track selected          ", 5, 10); //***********---------------***************------------********** Discuss with Brad
                            //call function to perform task
                            break;
                  
                        }
                    
                    // eo place code here ......
                    userSelection = 0;
                    }
                wait_ms(200);
            }//eo if kbhit
        }//eo while
        return userSelection;
}