#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"


extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];

int homePageHandler()
{
     int userSelection = 0;
     pageMenu[HOME].printMenu();
     
     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[HOME].erase();
                    userSelection = HOME;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[HOME].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[HOME].highlightNextItem();
                    break;
                case 0x07:
                    pageMenu[HOME].erase();
                    userSelection = pageMenu[HOME].getHighlightedItem();
                    exitCurrentMenu = true;
                    break;
                }//eo select
            wait_ms(200);
            }//eo if switch press detected
        }//eo while
        return userSelection;
}