

#include "menuIDs.h"
#include "MainMenu.h"

extern MainMenu pageMenu[MAXPAGES ];

void initializeMenuSystem()
{
    pageMenu[HOME].setMenuItem(0, RECORDSET, "Record Settings", 5, 2);
    pageMenu[HOME].setMenuItem(1, PLAYBACK, "Playback", 5, 3);
    pageMenu[HOME].setMenuItem(2, SCREENSET, "Screen Settings", 5, 4);
    pageMenu[HOME].setMaxItems(3);
    
    pageMenu[RECORDSET].setMenuItem(0, RECSETOUT, "Output", 5, 2);
    pageMenu[RECORDSET].setMenuItem(1, RECSETIN, "Input", 5, 3);
    pageMenu[RECORDSET].setMenuItem(2, RECSETFILTERS, "Filters", 5, 4);
    pageMenu[RECORDSET].setMenuItem(3, RECSETSAMPFRQ, "Sampling Freq", 5, 5);
    pageMenu[RECORDSET].setMenuItem(4, RECSETAGC, "AGC", 5, 6);
    pageMenu[RECORDSET].setMaxItems(5);
    
    pageMenu[OUTPUT].setMenuItem(0, LINE, "Line", 5, 2);
    pageMenu[OUTPUT].setMenuItem(1, HEADPHONES, "Headphones", 5, 3);
    pageMenu[OUTPUT].setMenuItem(2, SPEAKERS, "Speakers", 5, 4);
    pageMenu[OUTPUT].setMaxItems(3);
    
    pageMenu[INPUT].setMenuItem(0, INMIC, "Mic", 5, 2);
    pageMenu[INPUT].setMenuItem(1, INLINE, "Line", 5, 3);
    pageMenu[INPUT].setMaxItems(2);      

    pageMenu[FILTER].setMenuItem(0, FILTER1, "Low Pass", 5, 2);
    pageMenu[FILTER].setMenuItem(1, FILTER2, "High Pass", 5, 3);
    pageMenu[FILTER].setMenuItem(2, FILTER3, "Band Pass", 5, 4);
    pageMenu[FILTER].setMenuItem(3, FILTERNONE, "None", 5, 5);
    pageMenu[FILTER].setMaxItems(4);    
    
    pageMenu[SAMPRATE].setMenuItem(0, SPEED1, "ON", 5, 2);
    pageMenu[SAMPRATE].setMenuItem(1, SPEED2, "OFF", 5, 3);
    pageMenu[SAMPRATE].setMaxItems(2);     
    
    pageMenu[AGC].setMenuItem(0, AGCON, "ON", 5, 2);
    pageMenu[AGC].setMenuItem(1, AGCOFF, "OFF", 5, 3);
    pageMenu[AGC].setMaxItems(2);   
    
    pageMenu[PLAYBACK].setMenuItem(0, PLAYTRACK, "Play Saved Tracks", 5, 2);
    pageMenu[PLAYBACK].setMenuItem(1, DELETETRACK, "Delete Saved Tracks", 5, 3);
    pageMenu[PLAYBACK].setMaxItems(2);   
    
    pageMenu[PLAY].setMenuItem(0, EX_PLAYTRACK, "Example track", 5, 2);
    pageMenu[PLAY].setMaxItems(1); 
    
    pageMenu[DELETESCR].setMenuItem(0, EX_DELETETRACK, "Example track", 5, 2);
    pageMenu[DELETESCR].setMaxItems(1); 
    
    pageMenu[SCREENSET].setMenuItem(0, CONTRAST, "Contrast", 5, 2);
    pageMenu[SCREENSET].setMaxItems(1); 
    
    pageMenu[CONTRAST].setMenuItem(0, CONTRASTUP, "Increase Contrast", 5, 2);
    pageMenu[CONTRAST].setMenuItem(1, CONTRASTDOWN , "Decrease Contrast", 5, 3);
    pageMenu[CONTRAST].setMaxItems(2);   
    
//    pageMenu[PLAYSCR].setMenuItem(0, CONTRASTUP, "Increase Contrast", 5, 2);
//    pageMenu[PLAYSCR].setMenuItem(1, CONTRASTDOWN , "Decrease Contrast", 5, 3);
//    pageMenu[PLAYSCR].setMaxItems(2);  
    
    pageMenu[WARNINGSCR].setMenuItem(0, DELETENO, "Delete Track", 5, 2);
    pageMenu[WARNINGSCR].setMenuItem(1, DELETEYES , "DO NOT Delete", 5, 3);
    pageMenu[WARNINGSCR].setMaxItems(2);    
    
//    pageMenu[RECORDSCR].setMenuItem(0, CONTRASTUP, "Increase Contrast", 5, 2);
//    pageMenu[RECORDSCR].setMenuItem(1, CONTRASTDOWN , "Decrease Contrast", 5, 3);
//    pageMenu[RECORDSCR].setMaxItems(2);  

}