#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"
#include "HIDScope.h"
 
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led(LED_RED);
DigitalOut motor2direction(D4); //D4 en D5 zijn motor 2 (op het motorshield)
PwmOut motor2speed(D5);
DigitalIn button1(SW3);
HIDScope scope(2);
Ticker ScopeTime;
AnalogIn a_in(A0);

void ScopeSend()//Functie die de gegevens voor de scope uitleest en doorstuurt
{
    scope.set(0, motor2speed.read());
    scope.set(1, a_in.read());
    scope.send();
}

int main()
{
    motor2direction = 0;
    motor2speed = 0;
    led = 1;
    pc.baud(9600);
    pc.printf("Tot aan loop werkt");
    ScopeTime.attach_us(&ScopeSend, 10e4);
    
    
    while(true)
    {
           char c = pc.getc();
           
           switch(c)
           {
                case 'f':
                {
                    motor2direction = 1;
                    motor2speed = 0.9f;
                    pc.printf("het werkt\n");
                    wait(1);
                    led = 0;
                    wait(0.2f);
                    motor2speed = 0;
                    led = 1;
                    break;
                }
                
                case 'r':
                 {
                    motor2direction = 0;
                    motor2speed = 0.5f;
                    pc.printf("dit werkt ook\n");
                    wait(1);
                    led = 0;
                    wait(0.2f);
                    motor2speed = 0;
                    led = 1;
                    break;
                }
            }
    }   
}