#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"
#include "QEI.h"
 
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led(LED_RED);
DigitalOut motor2direction(D4); //D4 en D5 zijn motor 2 (op het motorshield)
PwmOut motor2speed(D5);
DigitalIn button1(SW3);
DigitalIn EncoderA(D3);
DigitalIn EncoderB(D2);
QEI Encoder(D3, D2, NC, 32);
HIDScope scope(3);
Ticker ScopeTime;
float Aantal_Degs;
float Aantal_pulses;
float Error;
float refference;
const float Kp = 0.005;


void ScopeSend()//Functie die de gegevens voor de scope uitleest en doorstuurt
{
    scope.set(0, motor2direction.read());
    scope.set(1, motor2speed.read());
    scope.set(2, Aantal_Degs);
    Aantal_Degs = Encoder.getPulses()*360/31/131;

    scope.send();
    
}


int main()
{
    motor2direction = 0;
    motor2speed = 0;
    led = 1;
    pc.baud(115200);
    float refference = 0;
    pc.printf("Tot aan loop werkt\n");
    ScopeTime.attach_us(&ScopeSend, 10e4);
    
    
    while (true) 
    {
        
        char c = pc.getc();   
        if(c == 'r')
        {
            refference = refference + 10;
            pc.printf("rx \n");
            Error = refference - Aantal_Degs;
            while(abs(Error) > 2)
                {
                    Error = refference - Aantal_Degs;
                    motor2speed = Kp*abs(Error);
                    pc.printf("reffence = %f,error = %f \n",refference,Error);
                    if(Error > 0)
                    {
                        motor2direction = 0;
                    }
                    else
                    {
                    motor2direction = 1;
                    }

                }
        }

        


    }
}