#include "mbed.h"
#include "stm32f103c8t6.h"
#define idc 2
#define idp 3
#define idw 4
#define pi 3.141592653589793115997963468544185161590576171875
#define speed_inc 0.20

CAN can (PA_11, PA_12);
Ticker copter;
Ticker planer;
Ticker wing;


void tCopter(){
    static double i = 0;
    static double f;
    i += speed_inc;
    if (i > 2) i = 0;
    f = (sin(i * pi) + 1.0) / 2 + 1; //1..2
    float send = static_cast<float>(f);
    can.write(CANMessage(idc, (char*)&send, sizeof(send)));
}

void tPlaner(){
    static double i = 0;
    static double f;
    i += speed_inc;
    if (i > 2) i = 0;
    f = (sin(i * pi) + 1.0) / 2 + 1; //1..2
    float send = static_cast<float>(f);
    can.write(CANMessage(idp, (char*)&send, sizeof(send)));
}

void tWing(){
    static double i = 0;
    static double f;
    i += speed_inc;
    if (i > 2) i = 0;
    f = (sin(i * pi) + 1.0) / 2 + 1; //1..2
    float send = static_cast<float>(f);
    can.write(CANMessage(idw, (char*)&send, sizeof(send)));
}

int main() {
    confSysClock();
    wait(1);
    copter.attach(&tCopter, 0.1);
    wait(3);
    planer.attach(&tPlaner, 0.1);
    wait(3);
    wing.attach(&tWing, 0.1);
    while(1) {
        //os mbed 03
    }
    while(1) {
        //os mbed 03
    }
}
