#include "mbed.h"
#include "chip.h"
#include "libuavcan/libuavcan/include/uavcan/build_config.hpp" //All default configuration options
#include "libuavcan/libuavcan_drivers/stm32/driver/include/uavcan_stm32/build_config.hpp" //OS detection; Any General-Purpose timer
#include "libuavcan/libuavcan/include/uavcan/node/subscriber.hpp" //Subscriber class
#include <uavcan/equipment/actuator/Command.hpp> //message type
#include "stm32f103c8t6.h"


static PwmOut servo(PA_8);
void move ();

extern uavcan::ICanDriver& getCanDriver();
extern uavcan::ISystemClock& getSystemClock();

const unsigned NodeMemoryPoolSize = 16384; // Need calulate (tutorial 2).
typedef uavcan::Node<NodeMemoryPoolSize> Node;

static Node& getNode() {
    static Node node(getCanDriver(), getSystemClock());
    return node;
}

int main() {
    confSysClock();
    auto& node = getNode();
    node.setNodeID(2);
    node.setName("Actuator");
    if (node.start() > 0){ //<>?
        //обработка ошибок запуска
    }
    uavcan::Subscriber <uavcan::equipment::actuator::Command> sub(node); //define node to subscriber
    if (sub.start(move) > 0) { //запуск чтения
        //обработка ошибок
    }
    
    node.setMoreOptional();
    float input = 0;
    while(1) {
        if (node.spin(uavcan::MonotonicDuration::getInfinite()) < 0){
            //обработчик ошибок
        }
    }
}

void move (const ReceivedDataStructure<DataType_>& msg){
    static bool a = true;
    if(a){
        servo.period_ms(20);
        a = false;
    }
    servo = (msg.command_value / pi) / 2 + 1 //лучше перевести это в коэффициент
}