#include "mbed.h"
#include "chip.h" //build configuration
#include "libuavcan/libuavcan/include/uavcan/build_config.hpp" //All default configuration options
#include "libuavcan/libuavcan_drivers/stm32/driver/include/uavcan_stm32/build_config.hpp" //OS detection; Any General-Purpose timer
#include "libuavcan/libuavcan/include/uavcan/node/publisher.hpp" //Publisher class
#include "stm32f103c8t6.h"

#include <uavcan/equipment/actuator/Command.hpp> //message type

extern uavcan::ICanDriver& getCanDriver();
extern uavcan::ISystemClock& getSystemClock();

const unsigned NodeMemoryPoolSize = 16384; // Need calulate (tutorial 2).
typedef uavcan::Node<NodeMemoryPoolSize> Node;

static Node& getNode() {
    static Node node(getCanDriver(), getSystemClock());
    return node;
}


int main() {
    confSysClock();
    auto& node = getNode();
    node.setNodeID(1);
    node.setName("Publisher");
    if (node.start() > 0){ //<>?
        //обработка ошибок запуска
    }
    uavcan::Publisher <uavcan::equipment::actuator::Command> pub(node); //define node to publisher
    if (pub.init() > 0) { //инициализация паблишера
        //обработка ошибок
    }
    
    node.setMoreOptional();
    
    while(1) {
        if (node.spin(uavcan::MonotonicDuration::fromMSec(1000)) < 1){
            //обработка ошибок
        }
        uavcan::equipment::actuator::Command msg;  
        msg.actuator_id = 2;
        msg.command_type = COMMAND_TYPE_POSITION //meter or radian
        msg.command_value = pi;
        
        if (pub.broadcast(msg) > 0){ // отправка сообщения
            // обработка ошибок
        }
        
        
    }
}
