#include "mbed.h"
#include "stm32f103c8t6.h"
#define val 0.05 // percents in step / 100
#define pi 3.141592653589793115997963468544185161590576171875

PwmOut Servo (PA_8);
DigitalOut myled(PC_13);
Ticker timer;


double f = 0; //first period
double i = 0;

void sinus (){
    Servo = (float)f * val; // duty-cycle, perсents 0..1; посчитанное значение вставится в следующее прерывание
    i += 0.1;
    if (i > 2) i = 0;
    f = (sin(i * pi) + 1.0) / 2 + 1; //1..2
}

int main() {
    confSysClock();
    Servo.period_ms(20);
    timer.attach(&sinus, val); //sine period, sec
    while(1) {
         myled = !myled;
         wait(0.5);
    }
}
