/*This is simple library for sinusoidal movement of servo 9g. For now it work with 1 Hz frequency only. Lib include 3 classes:
    *Servo_9g
        -for receiver: it define the Pin to which servo connected 
        -for transmiter: empty class
    *Servo_9g_Move
        -for one-plate interface: it maintain calculating of sine and movement of servo simultaneously
    *Servo_9g_CAN
        -for receiver: you need define Pin for servo and two pins for CAN-bus, and you may define the friquency of CAN-bus
        -for transmiter: you need define two pins for CAN-bus, and you may define the friquency of CAN-bus
Rus Uryadinsky prod*/
#include "mbed.h"
#define val 0.05 // percents in step / 100
#define pi 3.141592653589793115997963468544185161590576171875
#define speed_inc 0.20

class Servo_9g{
    public:
    Servo_9g();
    Servo_9g(PinName Pin);
    ~Servo_9g();
    
    protected:  
    PwmOut *Servo;
};


class Servo_9g_Move: public Servo_9g{
    public:
    Servo_9g_Move();
    Servo_9g_Move(PinName Pin);
    ~Servo_9g_Move();
    
    //set the sin and move the servo
    void StartMoveSin();
    
    protected:
    double f;
    Ticker timer;
    void Move(float f); //make move for your alg
    void NextSin(); //get next value of the sine
    
    private: //functions
    void CalCnMove();
    
    private: //variables
    double i; //f- func, i- count
};


class Servo_9g_CAN:public Servo_9g_Move{
    public:
    
    //constructors for transmiter
    Servo_9g_CAN(PinName rd, PinName td);
    Servo_9g_CAN(PinName rd, PinName td, int hz);
    
    //constructors for receiver
    Servo_9g_CAN(PinName servo_pwm, PinName rd, PinName td);
    Servo_9g_CAN(PinName servo_pwm, PinName rd, PinName td, int hz);
    ~Servo_9g_CAN();
    
    //for transmitting sine signal 1 Hz
    void SendSin();
    
    //send position to the Sub
    void sendPosition(char id, float pos);
    
    //for receiving of signal and movement of servo
    //1- complite, 0- error
    bool ReceiveServo();
     
    private: //functions
    void SendNextSin();
    
    private: //variables
    CAN can;
    CANMessage msg;
    
};
