#include "MS9g_move_sin.h"
//class Servo_9g
Servo_9g::Servo_9g(){}
Servo_9g::Servo_9g (PinName Pin){  
    Servo = new PwmOut(Pin);
    Servo->period_ms(20);
}

Servo_9g::~Servo_9g(){
    delete Servo;
}
//end of class Servo_9g

//class Servo_9g_Move
Servo_9g_Move::Servo_9g_Move():Servo_9g(){}
Servo_9g_Move::Servo_9g_Move(PinName Pin):Servo_9g(Pin){}
Servo_9g_Move::~Servo_9g_Move(){}

void Servo_9g_Move::Move (float a){
        Servo_9g::Servo->write(a * val); // duty-cycle, perсents 0..1
}
    
void Servo_9g_Move::NextSin(){
        i += speed_inc;
        if (i > 2) i = 0;
        f = (sin(i * pi) + 1.0) / 2 + 1; //1..2
}

void Servo_9g_Move::CalCnMove(){
    Move((float)f);
    NextSin();
}

void Servo_9g_Move::StartMoveSin(){
    timer.attach(this, &Servo_9g_Move::CalCnMove, val); //sine period, sec
}
//end of class Servo_9g_Move

//class Servo_9g_CAN
Servo_9g_CAN::Servo_9g_CAN(PinName rd, PinName td) :
    Servo_9g_Move(),
    can(rd, td)
{
    
}
Servo_9g_CAN::Servo_9g_CAN(PinName rd, PinName td, int hz) :
    Servo_9g_Move(),
    can(rd, td, hz)
{
    
}
    
Servo_9g_CAN::Servo_9g_CAN(PinName servo_pwm, PinName rd, PinName td) :
    Servo_9g_Move(servo_pwm),
    can(rd, td)
{
   CANMessage msg;
}

Servo_9g_CAN::Servo_9g_CAN(PinName servo_pwm, PinName rd, PinName td, int hz) :
    Servo_9g_Move(servo_pwm),
    can(rd, td, hz)
{
    CANMessage msg;
}

Servo_9g_CAN::~Servo_9g_CAN(){
    
}

void Servo_9g_CAN::SendNextSin(){
    NextSin();
    float send = static_cast<float>(f);
    can.write(CANMessage(2, (char*)&send, sizeof(send)));
}

bool Servo_9g_CAN::ReceiveServo(){
    if(can.read(msg)){
        if (msg.id == 2){
            float rec;
            memcpy(&rec, msg.data, sizeof(rec));
            Move(rec);
            return true;
        }
    }
    return false;
}
void Servo_9g_CAN::SendSin(){
    timer.attach(this, &Servo_9g_CAN::SendNextSin, val);
    
}
void Servo_9g_CAN::sendPosition(char id, float pos){
    can.write(CANMessage(id, (char*)&pos, sizeof(pos)));
}
//end of class Servo_9g_CAN