#include "mbed.h"
#include <string>

#define CTRL_REG1 0x2A
#define DATA_REG_W 0x3A
#define DATA_REG_R 0x3B

#define OUT_X_MSB 0x01

I2C accel(p9, p10);
DigitalIn piton(p30);

DigitalOut reset(p8);
Serial portCom(p13, p14);

int readRegister(char reg, char* data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    accel.start();
    ack = accel.write(DATA_REG_R);
    data[0] = accel.read(0);
    accel.stop();
    
    return ack;
}

int readRegisters(char reg, int range, char* dest)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    accel.start();
    ack = accel.write(DATA_REG_R);
    for (int i = 0; i < range - 1; i++)
        dest[i] = accel.read(1);
    dest[range - 1] = accel.read(0);
    accel.stop();
    
    return ack;
}

int writeRegister(char reg, char data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    ack = accel.write(data);
    accel.stop();
    
    return ack;
}

void SendTrame(string device, char data[])
{
    int length = 1;
    char size = 0x0F;
    if (device == "accel")
    {
        length = 6;
        size = 0x14;
    }
    
    char checkSum = 0x0;
    
    portCom.putc(0x7E);
    portCom.putc(0x00);
    portCom.putc(size);
    
    portCom.putc(0x10);
    portCom.putc(0x01);
    portCom.putc(0x00);
    portCom.putc(0x13);
    portCom.putc(0xA2);
    portCom.putc(0x00);
    portCom.putc(0x40);
    portCom.putc(0x0A);
    portCom.putc(0x2F);
    portCom.putc(0xB3);
    portCom.putc(0xFF);
    portCom.putc(0xFE);
    portCom.putc(0x00);
    portCom.putc(0x00);
    
    checkSum += 0x10 + 0x01 + 0x00 + 0x13 + 0xA2 + 0x00 + 0x40 + 0x0A + 0x2F + 0xB3 + 0xFF + 0xFE + 0x00 + 0x00;
    
    for (int a = 0; a < length; a++)
    {
        portCom.putc(data[a]);
        checkSum += data[a];
    }
    
    
    portCom.putc(0xFF - checkSum);
}

int main()
{
    reset = 0;
    wait(0.4);
    reset = 1;
    wait(4);
    
    // Mise de l'accéléromètre en standby
    writeRegister(CTRL_REG1, 0x10);
    
    // Set offset de l'accéléromètre
    writeRegister(0x31, 0xEE);
    
    // activate de l'accéléromètre
    char c;
    readRegister(CTRL_REG1, &c);
    writeRegister(CTRL_REG1, c | 0x01);
    
    char dataAccel[6] = {0};
    char dataContactSec[1] = {0};
    
    while(1)
    {
        int ack = readRegisters(OUT_X_MSB, 6, dataAccel);
        SendTrame("accel", dataAccel);
        
        dataContactSec[0] = piton;
        SendTrame("contactSec", dataContactSec);
        
        wait(0.2);
    }
}
