#ifndef ROUTEUR_HPP
#define ROUTEUR_HPP

#include <string>
#include "trame.hpp"

#define CTRL_REG1 0x2A
#define DATA_REG_W 0x3A
#define DATA_REG_R 0x3B

#define OUT_X_MSB 0x01

using namespace std;

class Routeur
{
public:
    // Constructeur
    Routeur(PinName _tx, PinName _rx);
    
    void initAccel();
    void sendAccelValues();
    
    void sendSwitchValue();
    
private:
    int readRegister(char reg, char* data);
    int readRegisters(char reg, int range, char* dest);
    int writeRegister(char reg, char data);
    
    Trame trame;
    
    I2C accel;
    DigitalIn piton;
    
    char switchValue[1];
    char accelValues[6];
};

#endif
