#include "routeur.hpp"

const char COORD_ADRESS[8] = {0x00, 0x13, 0xA2, 0x00, 0x40, 0x0A, 0x2F, 0xB3};

Routeur::Routeur(PinName _tx, PinName _rx) :
    trame(_tx, _rx), accel(p9, p10), piton(p30)
{
    DigitalOut reset(p8);
    
    reset = 0;
    wait(0.4);
    reset = 1;
    wait(4);
}

void Routeur::initAccel()
{
    // Mise de l'accéléromètre en standby
    writeRegister(CTRL_REG1, 0x10);
    
    // Set offset de l'accéléromètre
    writeRegister(0x31, 0xEE);
    
    // activate de l'accéléromètre
    char c;
    readRegister(CTRL_REG1, &c);
    writeRegister(CTRL_REG1, c | 0x01);
}

void Routeur::sendSwitchValue()
{
    switchValue[0] = piton;
    
    trame.sendTransmitRequest(COORD_ADRESS, switchValue, 1);
}

void Routeur::sendAccelValues()
{
    int ack = readRegisters(OUT_X_MSB, 6, accelValues);
    
    trame.sendTransmitRequest(COORD_ADRESS, accelValues, 6);
}

int Routeur::readRegister(char reg, char* data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    accel.start();
    ack = accel.write(DATA_REG_R);
    data[0] = accel.read(0);
    accel.stop();
    
    return ack;
}

int Routeur::readRegisters(char reg, int range, char* data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    accel.start();
    ack = accel.write(DATA_REG_R);
    for (int i = 0; i < range - 1; i++)
        data[i] = accel.read(1);
    data[range - 1] = accel.read(0);
    accel.stop();
    
    return ack;
}

int Routeur::writeRegister(char reg, char data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    ack = accel.write(data);
    accel.stop();
    
    return ack;
}
