#include "events.h"

/*pindetect pins on the mbed*/
PinDetect Top_Button (p13);
PinDetect Near_Top_Button (p14);
PinDetect Near_Bottom_Button (p15);
PinDetect Bottom_Button (p16);
PinDetect Top_Call_Button (p17);
PinDetect Bottom_Call_Button (p19);
PinDetect Go_Top_Button (p20);
PinDetect Go_Bottom_Button (p21);
PinDetect Safety (p22);
/*definitions*/
events ev_q [q_size];
int load=0,unload=0;

void new_event(events ev) {//function for new event
    ev_q[load++]= ev;//each time move the load to the next array
    if (load==q_size)//load equal to the size of array
        load=0;//load back to first array
}
int empty_q (void) {//function for empty array
    return load==unload;//when unload and load are equal
}
events get_event(void) {//function for getting event
    events e;//declearing the ev
    do printf("");
    while (load==unload);
    e=ev_q[unload++];//each time move the unload to the next array
    if (unload==q_size)//unload equal to the size of array
        unload=0;//unload back to first array
    return e;//return to the fisrt event
}

//event functions
void top_button () {
    new_event(ev_Top_Button);
}
void near_top_button () {
    new_event(ev_Near_Top_Button);
}
void near_bottom_button () {
    new_event(ev_Near_Bottom_Button);
}
void bottom_button () {
    new_event(ev_Bottom_Button);
}
void top_call_button () {
    new_event(ev_Top_Call_Button);
    call_to_top=1;
}
void bottom_call_button () {
    new_event(ev_Bottom_Call_Button);
    call_to_bottom=1;
}
void go_top_button () {
    new_event(ev_Go_To_Top_Button);
}
void go_bottom_button () {
    new_event(ev_Go_To_Bottom_Button);
}
void safety () {
    new_event(ev_Safety);
}

//pin detect function for the buttons (events)
void initialise_events(void) {

    Top_Button.mode(PullUp);
    Top_Button.setAssertValue( 0 );
    Top_Button.attach_asserted(&top_button);
    Top_Button.setSampleFrequency();

    Near_Top_Button.mode(PullUp);
    Near_Top_Button.setAssertValue( 0 );
    Near_Top_Button.attach_asserted(&near_top_button);
    Near_Top_Button.setSampleFrequency();

    Near_Bottom_Button.mode(PullUp);
    Near_Bottom_Button.setAssertValue( 0 );
    Near_Bottom_Button.attach_asserted(&near_bottom_button);
    Near_Bottom_Button.setSampleFrequency();

    Bottom_Button.mode(PullUp);
    Bottom_Button.setAssertValue( 0 );
    Bottom_Button.attach_asserted(&bottom_button);
    Bottom_Button.setSampleFrequency();

    Top_Call_Button.mode(PullUp);
    Top_Call_Button.setAssertValue( 0 );
    Top_Call_Button.attach_asserted(&top_call_button);
    Top_Call_Button.setSampleFrequency();

    Bottom_Call_Button.mode(PullUp);
    Bottom_Call_Button.setAssertValue( 0 );
    Bottom_Call_Button.attach_asserted(&bottom_call_button);
    Bottom_Call_Button.setSampleFrequency();

    Go_Top_Button.mode(PullUp);
    Go_Top_Button.setAssertValue( 0 );
    Go_Top_Button.attach_asserted(&go_top_button);
    Go_Top_Button.setSampleFrequency();

    Go_Bottom_Button.mode(PullUp);
    Go_Bottom_Button.setAssertValue( 0 );
    Go_Bottom_Button.attach_asserted(&go_bottom_button);
    Go_Bottom_Button.setSampleFrequency();

    Safety.mode(PullUp);
    Safety.setAssertValue( 0 );
    Safety.attach_asserted(&safety);
    Safety.setSampleFrequency();
}