#include "Motor.h"

/*definitions*/
float sp_incr;
float current_sp;
int time_incr;
float speed_at_0_time;
Ticker Motor_Ticker;
Servo motor_speed(p26);

/*Function for incrementing the speed and the time of the motor*/
void motor(float fin_speed, int ramp_time) {
    if (ramp_time) {
        sp_incr = (fin_speed - current_sp) / float(ramp_time);
        time_incr = ramp_time;
        printf("Motor going to speed %f over %f seconds\n",fin_speed,float(ramp_time)/1000);
    } else {
        motor_speed = fin_speed;
        printf("Motor at speed %f now\n",fin_speed);
        current_sp = fin_speed;
    }

}

/*This function is used to run the Ticker (update motor)*/
void update_motor (void) {
    if (time_incr) {
        current_sp += sp_incr;
        if (current_sp>1.0) {        //If the speed is more than 1 it means it's 1 because the servo motor only accept 1 and 0.
            current_sp=1;
        }
        if (current_sp<0.0) {       //If the speed is less than 0 it will be equal to 0.
            current_sp=0;
        }
        motor_speed = current_sp;
        time_incr --;               //the time that is fed to the motor will decrement and then it will start running.
    }
}

/*The Ticker function which runs the function above after a certain time continually*/
void Starting_Motor (void) {
    speed_at_0_time=0.5;                      //the motor is turned off at (time=0) and speed (0.5)
    motor_speed=speed_at_0_time;
    time_incr=0;
    Motor_Ticker.attach(&update_motor,0.001);
}