/***********************************************************************/

/*          STATE MACHINE ASSIGMENT_ENB5050                            */

/*          Written by Rufaida A.Rhim ,Noora A.Aziz                    */

/*          Date  13-May-2012                                          */

/*          This program is written for ELEVATOR                       */

/***********************************************************************/

#include "mbed.h"
#include "definitions.h"
#include "actions.h"
#include "events.h"
#include "ding.h"
#include "door_leds.h"
#include "Motor.h"

events event;
states state;

/*check the program on PuTTY */
const char event_lookup[MAX_EVENTS][25] ={"ev_Go_To_Bottom_Button", "ev_Go_To_Top_Button", "ev_Bottom_Call_Button", "ev_Top_Call_Button", "ev_Near_Top_Button", "ev_Near_Bottom_Button", "ev_Top_Button", "ev_Bottom_Button", "ev_Timeout", "ev_Safety","ev_loading_event"};
const char state_lookup[MAX_STATES][25] ={"st_At_Top_Closed", "st_Going_Bottom", "st_Wait_For_Bottom", "st_Wait_For_Ding_Bottom", "st_Wait_For_door_Bottom","st_At_Bottom_Closed", "st_Going_Up","st_Wait_For_Top,", "st_Wait_For_Ding_Top", "st_Wait_For_door_Top", "st_Wait_For_Safety", "st_Wait_For_Bottom_Floor"};

/* This is the state table with actions, states, and events */
void (*const state_table [MAX_STATES][MAX_EVENTS]) (void)={
//    ev_Go_To_Bottom_Button          ev_Go_To_Top_Button         ev_Bottom_Call_Button            ev_Top_Call_Button           ev_Near_Top_Button              ev_Near_Bottom_Button           ev_Top_Button                ev_Bottom_Button              ev_Timeout                           ev_Safety               ev_loading_event
    {     act_ramp_motor_down,            act_open_close_Top_door,    act_ramp_motor_down,             act_open_close_Top_door,   do_nothing,                     do_nothing,                     act_stop_motor_ding_top,     do_nothing,                   do_nothing,                          act_slow_to_dowm,     do_nothing              },        //function for state st_At_Top_Closed
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     act_slow_speed_down,            do_nothing,                  do_nothing,                   do_nothing,                          do_nothing,           do_nothing              },        //function for state st_Going_Bottom
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     act_slow_speed_down,            do_nothing,                  act_stop_motor_ding_bottom,   do_nothing,                          do_nothing,           do_nothing              },        //function for state st_Wait_For_Bottom
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     do_nothing,                  do_nothing,                   act_open_close_Bottom_door,          do_nothing,           do_nothing              },        //function for state st_Wait_For_Ding_Bottom
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     do_nothing,                  do_nothing,                   act_bottom_close,                    do_nothing,           do_nothing              },        //function for state st_Wait_For_door_Bottom
    {     act_open_close_Bottom_door,     act_ramp_motor_up,          act_open_close_Bottom_door,      act_ramp_motor_up,         do_nothing,                     do_nothing,                     do_nothing,                  act_stop_motor_ding_bottom,   do_nothing,                          do_nothing,           do_nothing              },        //function for state st_At_Bottom_Closed
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                act_slow_speed_up,              do_nothing,                     do_nothing,                  do_nothing,                   do_nothing,                          act_slow_to_dowm,     do_nothing              },        //function for state st_Going_Up
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     act_stop_motor_ding_top,     do_nothing,                   do_nothing,                          act_slow_to_dowm,     do_nothing              },        //function for state st_Wait_For_Top
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     do_nothing,                  do_nothing,                   act_open_close_Top_door,             do_nothing,           do_nothing              },        //function for state st_wait_For_Ding_Top
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     do_nothing,                  do_nothing,                   act_top_close,                       do_nothing,           do_nothing              },        //function for state st_Wait_For_door_Top
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     do_nothing,                  do_nothing,                   do_nothing,                          act_slow_to_dowm,     do_nothing              },         //function for state st_Wait_For_Safety
    {     do_nothing,                     do_nothing,                 do_nothing,                      do_nothing,                do_nothing,                     do_nothing,                     do_nothing,                  act_stop_motor_ding_bottom,   do_nothing,                          do_nothing,           do_nothing              },        //function for state st_Wait_For_Bottom_Floor

};
/*the main function which starts the doors,motor and ding*/
int main (void) {
    Starting_Motor();
    initialise_events();
    Start_up_sound();
    Starting_LEDS();
    motor(up_slow,0);

    state = st_Wait_For_Safety;
    printf("Statrting State: %s\n",state_lookup[state]);


    while (1) {
        event=get_event();
        printf("Event: %s    ",event_lookup[event]);
        state_table[state][event]();
        printf("State: %s\n",state_lookup[state]);
    }
}