#include "door_leds.h"

/*definitions*/
DigitalOut latch (p8);          //Connecting the latch of the LED driver to (pin 8) of the embed
SPI port(p5, p6, p7);          //Using the SPI pins in the embed
SPI spi(p5, p6, p7);
int LED_Pos;
int Level;
Ticker timer;

/*finction to know the level (top or bottom) and the total LEDS and the flashing*/
void Open_Close_Door(int i) {
    Level=i;
    LED_Pos=24;       //The total LED for each door is 2x24
}

/*Function for the Ticker (LED doors update)*/

void DOORS_LED (void) {
    if (LED_Pos) {

        spi.write(door_leds[Level][--LED_Pos]);
        latch=1;
        latch=0;
        if (LED_Pos==0)
            new_event(ev_Timeout);
    }
}

/*The Ticker function to start opening and closing the door*/

void Starting_LEDS (void) {
    latch=0;
    spi.format (16,0);
    spi.write(0xFFFF);
    latch=1;
    latch=0;
    LED_Pos=0;
    timer.attach(&DOORS_LED,0.2);
}