#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "stdlib.h"

/**   The integers to show whether the enemies could be used again */
struct eninumber{
    int p1; /**< The first integer to show whether the ship is been hit*/
    int p2; /**< The second integer to show whether the ship is been hit*/
    };

/** enemies Class
@brief Library for setting the numbers that shows whether there is a ship on the lcd and if not, generate one.
@brief The library also could set random ship coordinates.
@brief The library can generate two types of ships.


@brief Revision 1.0

@author Miao Sixiang
@date   18th April 2019

@code
#include "mbed.h"
 #include "Gamepad.h"
 #include "N5110.h"
 #include "enemies.h"
 #include "math.h"
 #include "ship.h"
 #include "Bitmap.h"
 
 
#ifdef WITH_TESTING
#include "tests.h"
#endif


DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);
DigitalOut led1(PTA1);
DigitalOut led2(PTA2);
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11); 

Gamepad pad;
enemies eni;
ship shi;

void init();
void welcome();
bool explosionjudge(float x1,float y1,float x2,float y2);
void explosion(int x, int y);
void game_over();

float xp1,xp2,yp1,yp2,xn1,yn1,xn2,yn2,x,y,x1,y1,x2,y2,v;
int p1,p2,score,high_score,count;
Vector2D enic1 = {xn1, yn1};
Vector2D enic2 = {xn2, yn2};
const int explosion123[10][10] =      {
    { 0,0,0,0,1,0,0,0,0,0 },
    { 0,1,0,1,0,1,0,0,1,0 },
    { 0,1,0,1,0,1,1,1,1,0 },
    { 0,0,1,0,0,0,0,1,0,0 },
    { 0,1,0,0,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,0,0,1,0 },
    { 0,0,1,0,0,0,0,1,0,0 },
    { 0,1,0,1,0,0,1,1,0,0 },
    { 1,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,0,0,0,0,0,0,0 },
};

int main() {
    
    //initial all the components 
    init();//the lcd is initialed
    lcd.init();
    lcd.normalMode();
    lcd.setContrast(0.5);
    
    
    count = 0;
    score = 0;
    x = 5.0;
    y = 21.0;
    x1 = 0.0;
    y1 = 0.0;
    x2 = 0.0;
    y2 = 0.0;
    v = 4.0;
    p1 = p2 = 0;
    xp1 = xp2 = xn1 =xn2 =0.0;
    yp1 = yp2 = yn1 = yn2 =0.0;
    enic1.x = enic2.x = 0.0;
    
    high_score = 0;
    
    shi.set_ship(y,x,lcd);
    
    welcome();
        while (1) {
        lcd.clear();
        Vector2D coord = pad.get_mapped_coord();
        x = x + coord.x;
        y = y - coord.y;
        shi.set_ship(y,x,lcd);
        
        if (pad.check_event(Gamepad::A_PRESSED)){
            if (x1 == 0){
                    x1 = x;
                    y1 = y;
                    x1 = shi.open_fire(x1,y1,v,lcd);
                    if (!x2 ==0){
                    x2 = shi.open_fire(x2,y2,v,lcd);
                    }
                }  else if (x1 > 0 and x2 == 0){
                    x2 = x;
                    y2 = y;
                    x2 = shi.open_fire(x2,y2,v,lcd);
                    x1 = shi.open_fire(x1,y1,v,lcd);
            } else if (x1 > 0 and x2 > 0){
                x2 = shi.open_fire(x2,y2,v,lcd);
                x1 = shi.open_fire(x1,y1,v,lcd);
                }
        } else if (x1 > 0 or x2 > 0) {
            if (x1 > 0){
            x1 = shi.open_fire(x1,y1,v,lcd);
            } 
            if (x2 > 0){
                x2 = shi.open_fire(x2,y2,v,lcd);
                }
            }
        if (x1 >= 84){
             x1 = 0;
                }
        if (x2 >= 84) {
            x2 = 0;
            }
        
        
        
        eninumber enin = eni.enemiesjudge(enic1.x, enic2.x);
        p1 = enin.p1;
        p2 = enin.p2;
        if (p1 == 1){
        enic1 = eni.set_coord1(p1);
        }
        if (p2 == 1){
        enic2 = eni.set_coord1(p2);
        }
        eni.drawenemies_small(enic1.x, enic1.y,lcd);
        eni.drawenemies_large(enic2.x, enic2.y,lcd);
        
        
        if (explosionjudge(enic1.x,enic1.y,x1,y1)) {
            explosion(x1, y1);
            x1 = 0;
            count = count + 1;
            enic1.x = 0;
            } 
        if (explosionjudge(enic2.x,enic2.y,x1,y1)) {
            explosion(x1, y1);
            x1= 0;
            count = count + 1;
            enic2.x = 0;
            }
            if (explosionjudge(enic1.x,enic1.y,x2,y2)) {
            explosion(x1, y1);
            x2 = 0;
            count = count + 1;
            enic1.x = 0;
            } 
        if (explosionjudge(enic2.x,enic2.y,x2,y2)) {
            explosion(x2, y2);
            count = count + 1;
            x2 = 0;
            enic2.x = 0;
            }
            
            
            score = count *50;
            
                    
        if (xp1 <= 4) {
            xp1 = enic1.x;
            yp1 = enic1.y;
            }else if (xp1 > 0) {
                xp1 = eni.open_fire_en(xp1, yp1,lcd);
                }
        if (xp2 <= 4){
            xp2 = enic2.x;
            yp2 = enic2.y;
            }else if (xp2 > 0) {
             xp2 = eni.open_fire_en(xp2, yp2,lcd);
            }
            
            if (score > high_score){
            high_score = score;
            }
                  
        if (explosionjudge(x,y,xp1,yp1)) {
            explosion(xp1, yp1);
            xp1 = 0;
            game_over();
            }
          if (explosionjudge(x,y,xp2,yp2)) {
            explosion(xp2, yp2);
            xp2 = 0;
            game_over();
            }
            
        
    
        
        wait(0.1);
       lcd.refresh();
    }
}






void init()
{
    // need to initialise LCD and Gamepad 
    pad.init();
    
    count = 0;
    score = 0;
    x = 5.0;
    y = 21.0;
    x1 = 0.0;
    y1 = 0.0;
    x2 = 0.0;
    y2 = 0.0;
    v = 4.0;
    p1 = p2 = 0;
    xp1 = xp2 = xn1 =xn2 =0.0;
    yp1 = yp2 = yn1 = yn2 =0.0;
    enic1.x = enic2.x = 0.0;
     
    // initialise the game with correct ball and paddle sizes

}



void welcome() {
    
    lcd.printString("   HALO WAR    ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
        
    }
}

bool explosionjudge(float x1,float y1,float x2,float y2){
        float d;
        d = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        if (d <= 9){     
          return true;
        }else {
            return false;
            }
        }
        
void explosion(int x, int y){
    
    lcd.drawSprite(x, y, 10, 10, (int *)explosion123);
    }
    
    
void game_over(){
    while(!pad.check_event(Gamepad::START_PRESSED)){
        char buffer1[20];
        sprintf(buffer1, "High Score=%d", high_score);
        lcd.printString(buffer1,0,0);
        char buffer[14];
        sprintf(buffer, "  Score = %d ", score);
        lcd.printString(buffer,0,1);
    lcd.printString("   Wasted    ",0,2);  
    lcd.printString("Press start to",0,3);
    lcd.printString(" new compaign",0,4);
    lcd.refresh();
    lcd.clear();
    }
    init();
    }

@endcode
*/

class enemies
{
public:

/** Judge whether there are any enemy ships in the lcd.
    *
    * @param xp1  The horizontal position of the first ship, if xp1 <= 0, means that the fisrt ship is not on the lcd.
    * @param xp2  The horizontal position of the second ship, if xp2 <= 0, means that the second ship is not on the lcd.
    * @returns
    * There are two elements in the struct, both 1 or 0;
    *       0    - There is already a ship on the lcd.
    *       1    - The ship could be draw on the lcd again.
    *
    */
eninumber enemiesjudge(int xp1, int xp2);



/** To draw an enemy ship on the lcd, the smaller one, at the given position.
    *
    * @param x  The horizontal position of the ship, set the core of the ship at x.
    * @param y  The vertical position of the ship, set the core of the ship at y.
    *
    */
void drawenemies_small(float x, float y, N5110 &lcd);


/** To set new coordinates for the new ships.
    *
    * @param p1  The integer that could ensure whether the ship could be generated.
    * @returns
    * There are two elements in the vector.
    *      x   -The horizontal coordinate of the enemy ship
    *      y   -The vertical coordinate of the enemy ship
    */
Vector2D set_coord1(int p1);


/** To set new coordinates for the new ships.
    *
    * @param p2  The integer that could ensure whether the ship could be generated.
    * @returns
    * There are two elements in the vector.
    *      x   -The horizontal coordinate of the enemy ship
    *      y   -The vertical coordinate of the enemy ship
    */
Vector2D set_coord2(int p2);


/** To set a missile released by the enemies.
    *
    * @param x  The horizontal coordinate of the enemy ship that will release missile.
    * @param y  The vertical coordinate of the enemy ship that will release missile.
    * @returns
    * The last coordinate of the missile.
    *      x   -The horizontal coordinate of the missile
    *
    */
int open_fire_en(int x, int y, N5110 &lcd);


/** To draw an enemy ship on the lcd, the larger one, at the given position.
    *
    * @param x  The horizontal position of the ship, set the core of the ship at x.
    * @param y  The vertical position of the ship, set the core of the ship at y.
    *
    */
void drawenemies_large(float x, float y, N5110 &lcd);

private:
int _p1;
int _p2;
float _xp1;
float _yp1;
float _xp2;
float _yp2;
int _vp;
};
