//Include de nodigige library
#include "mbed.h"
#include "TextLCD.h"
#include "Servo.h"
#include "ds1307.h"
#include <time.h>  
#include "EthernetInterface.h"
#include "Websocket.h"

//Defineer de ingangen en uitgangen
DigitalOut myled(LED1);
AnalogIn LM35_1(p15);
AnalogIn LM35_2(p16);
AnalogIn LM35_3(p17);
AnalogIn LM35_4(p18);
AnalogIn Potmeter(p19); 
Servo myservo(p24);
TextLCD lcd(p12,p11,p8,p7,p6,p5);
DigitalOut Relais(p13);
PwmOut b (p21);
PwmOut g (p22);
PwmOut r (p23);
DigitalIn SW_1(p30);
DigitalIn SW_2(p29);
DigitalIn SW_3(p28);
DigitalIn SW_4(p27);
DS1307 my1307(p9,p10);

//Maak globale variable aan
float duty_red,duty_green;                  //Bevat de duty cycle van de RBG led
float LMTemp_1,LMTemp_2,LMTemp_3,LMTemp_4;  //Bevat de berekende temperatuur van de temp senor
int menu = 0;                               //Bevat de waarde van het huidige menu
float instelliving = 20;                    //Standaart instelling voor de gevraagde living temperatuur
float instelkeuken = 20;                    //Standaart instelling voor de gevraagde keuken temperatuur
float instelslaap = 20;                     //Standaart instelling voor de gevraagde slaapkamer temperatuur
int sec,min,uur,dag,datum,maand,jaar;       //Bevat de huidige tijd en datum
int startsec = 0;                           //Standaard instelling voor de startijd (seconden)
int startmin = 0;                           //Standaard instelling voor de startijd (minuten)
int startuur = 7;                           //Standaard instelling voor de startijd (uren)
int stopsec = 0;                            //Standaard instelling voor de stoptijd (seconden)
int stopmin = 0;                            //Standaard instelling voor de stoptijd (minuten)
int stopuur = 23;                           //Standaard instelling voor de stoptijd (uren)
int timerwijzigen = 0;                      //Bevat de timerwaarde om in de instellingen van de stop of startijd te wijzigen
int flikertimer = 0;                        //Bevat de waarde van de timer om het tewijzigen deel te laten flikkeren
int wijzigmenustart = 0;                    //Bevat de waarde van welk deel menu dat men wilt wijzigen uur,min,sec (startijd)
int wijzigmenustop = 0;                     //Bevat de waarde van welk deel menu dat men wilt wijzigen uur,min,sec (stoptijd)
float stooklijn = 0;                        //Bevat de huidige waarde van de stooklijn
int menubuffer = 0;                         //Bevat de waarde van het hoofdmenu voordat er automatich naar de menu stooklijn word geprongen
int showtimer = 0;                          //Bevat de waarde van de timer hoe lang stooklijn op het display wordt gezet
bool showstooklijn = false;                 //Wordt true wanneer de stooklijn moet worden weergegeven
float hysteresis = 1.5;                     //Standaart instelling voor de hysteresis
bool hysteresisbuffer[3];                   //Buffer voor de hysteresis te berekenen 3 ellementen [living,keuken,slaapkamer]
float position = 0;                         //Standaart positie van de servomotor
bool aan = true;                            //Standaart staat de verwarming aan totdat men de stoptijd voorbij komt

//------------------------------------------------------------------- 
//----Functie voor het bepalen of er moet worden verwarmt of niet----
//-------------------------------------------------------------------
void onoff(int status){
    if (status >= 1){                               //Kijken of er ergens warmte wordt gevraagt
        Relais = 1;                                 //Maak de uitgang van de relais hoog
            duty_red=duty_red+0.0005;               //Verhoog de duty cycle met 0.0005
            duty_green=duty_green-0.0005;           //Verlaag de duty cycle met 0.0005
            if (duty_red >= 1) (duty_red = 1);      //Wanneer de dutcycle gelijk is aan 1 maak deze dan altijd 1 zodat de rode led constand oplicht
            if (duty_green <= 0) (duty_green = 0);  //Wanneer de dutcycle gelijk is aan 0 maak deze dan altijd 0 zodat de groene led constand gedooft is
            r.write(duty_red);                      //Schrijf de dutcycle van de rode led weg naar de pwm uitgang van de rode led
            g.write(duty_green);                    //Schrijf de dutcycle van de groen led weg naar de pwm uitgang van de groen led
        }
    else {                                          //Wanneer er geen warmte wordt gevraagt...
        Relais = 0;                                 //Maak de uitgang van de relais laag
            duty_red=duty_red-0.0005;               //Verlaag de duty cycle met 0.0005
            duty_green=duty_green+0.0005;           //Verhoog de duty cycle met 0.0005
            if (duty_red <= 0) (duty_red = 0);      //Wanneer de dutcycle gelijk is aan 0 maak deze dan altijd 0 zodat de rode led constand gedooft is
            if (duty_green >=1) (duty_green = 1);   //Wanneer de dutcycle gelijk is aan 1 maak deze dan altijd 1 zodat de groen led constand oplicht
            r.write(duty_red);                      //Schrijf de dutcycle van de rode led weg naar de pwm uitgang van de rode led
            g.write(duty_green);                    //Schrijf de dutcycle van de groen led weg naar de pwm uitgang van de groen led
         }
 }
 
 //-----------------------------------------------------------------
 //------------Functie voor het uitlezen van de LM35----------------
 //-----------------------------------------------------------------
 float LM35 (int sensor){
     float waardes[100] = {0};                              //Maak een lokale variabele aan van 100 elementen met als waarde 0
     float gemiddelde = 0;                                  //Maak een lokale variabele aan waarin de 100 elementen bij elkaar zijn opgeteld
     float temperatuur = 0;                                 //Maak een lokale variabele aan die de juiste temperatuur bevat
     
     for(int i=0;i<100;i++){                                //Lees de sensor 100 keer uit en zet de waardes in de variabele 'waardes'
         if (sensor == 1) (waardes[i] = LM35_1.read());
         if (sensor == 2) (waardes[i] = LM35_2.read());     //Lees enkel de gevraagde sensor uit
         if (sensor == 3) (waardes[i] = LM35_3.read());
         if (sensor == 4) (waardes[i] = LM35_4.read());
         wait(0.00001);                                     //Wacht heel even voor de volgende meting
         }
    
    for(int i=0;i<100;i++){                                 //Doorloop alle elemenenten van de variabele 'waardes'
        gemiddelde = gemiddelde + waardes[i];               //Verhoog de gemidelde waarde met de waarde die in het huidige element staat
        }
    
    temperatuur = ((gemiddelde /100) * 368.5503686)- 6;     //Bereken de temperatuur door het gemidelde te delen door het aantal elementen en te vermenigvuldigen met een constante
    return temperatuur;                                     //Stuur de waarde van 'temperatuur' terug
} 

//------------------------------------------------------------------
//------------------Functie voor de stooklijn-----------------------
//------------------------------------------------------------------
float stooklijnfunctie (float huidige){ 
     float analoog = Potmeter * 3;                                      //Maak een lokale variabele aan die de waarde van de analoge ingang * 3 bevat
        if (huidige - analoog > 0.1 | analoog - huidige > 0.1){         //Kijk of de stooklijn met meer of minder dan 0.1 is veranderd 
            if(showstooklijn == false) (menubuffer = menu);             //Als 'showstooklijn' is false sla dan het huidige menu op in de menubuffer
            showstooklijn = true;                                       //Maak de 'showstooklijn' variabele true zodat de menubuffer niet wordt aangepast
            menu = 8;                                                   //Laat menu 8 op het display verschijnen (Stooklijn)
         }
        else (analoog = huidige);                                       //Als de verandering van de stooklijn kleinder is dan 0.1 geef de huidige waarde dan terug
        
        if (showstooklijn == true & menu != 8)(showstooklijn = false);  //Zet 'showstooklijn' op false als er naar een ander menu wordt gegaan 
        if (showstooklijn == true & menu == 8){                         //Wanneer menu 8 wordt getoond en 'showstooklijn' is true...
         showtimer = showtimer + 1;                                     //Incrementeer 'showtimer' met 1
         if (showtimer > 3000) {                                        //Wanneer de 'showtimer' groter is dan 3000...   3000 is +- 3 seconden
            menu = menubuffer;                                          //Zet de vorige menu terug op het LCD
            showstooklijn = false;                                      //Zet de showstooklijn terug op false
            showtimer = 0;                                              //Clear de showstooklijn timer
            }
        }
      return analoog;                                                   //Geef de nieuwe waarde van de stooklijn terug
}

//------------------------------------------------------------------
//----Functie voor dag nummers om te zetten naar dag benamingen-----
//------------------------------------------------------------------
const char* dagen (int dag){
    const char* dagbenaming ="";                //Maak een variable aan waarin de huidige dag benaming komt te staan
    
    //Zet de dag nummer om in een dag benaming
    if (dag == 1) (dagbenaming = "Ma");
    else if (dag == 2) (dagbenaming = "Di");
    else if (dag == 3) (dagbenaming = "Wo");
    else if (dag == 4) (dagbenaming = "Do");
    else if (dag == 5) (dagbenaming = "Vr");
    else if (dag == 6) (dagbenaming = "Za");
    else if (dag == 7) (dagbenaming = "Zo");    
    
return dagbenaming;                             //Geef de huidige dag benaming terug
    }
    
 //-----------------------------------------------------------------
 //---------Functie voor het berekenen van de warmtevraag-----------
 //-----------------------------------------------------------------
 int aantalwarmtevraag (){
     int aantal =0;          //Reset de variabele
     
     //Kijk of er warmt wordt gevraagt in de living
     if (LMTemp_1 < (instelliving - (hysteresis /2)) & hysteresisbuffer[0] == false) (hysteresisbuffer[0] = true);
     if (LMTemp_1 < (instelliving - (hysteresis /2)) | hysteresisbuffer[0] == true ) (aantal = aantal + 1);
     if (LMTemp_1 > (instelliving + (hysteresis /2))) (hysteresisbuffer[0] = false);
     
     //Kijk of er warmt wordt gevraagt in de keuken
     if (LMTemp_2 < (instelkeuken - (hysteresis /2)) & hysteresisbuffer[1] == false) (hysteresisbuffer[1] = true);
     if (LMTemp_2 < (instelkeuken - (hysteresis /2)) | hysteresisbuffer[1] == true ) (aantal = aantal + 1);
     if (LMTemp_2 > (instelkeuken + (hysteresis /2))) (hysteresisbuffer[1] = false);
     
     //Kijk of er warmt wordt gevraagt in de slaapkamer
     if (LMTemp_3 < (instelslaap - (hysteresis /2)) & hysteresisbuffer[2] == false) (hysteresisbuffer[2] = true);
     if (LMTemp_3 < (instelslaap - (hysteresis /2)) | hysteresisbuffer[2] == true ) (aantal = aantal + 1);
     if (LMTemp_3 > (instelslaap + (hysteresis /2))) (hysteresisbuffer[2] = false);
    
    //Kijk of dat de huidige tijd tussen het start uur en het stop uur zit
    if (uur == startuur & min == startmin & sec == startsec) (aan = true);
    if (uur == stopuur & min == stopmin & sec == stopsec) (aan = false);
    
    if (aan == false) (aantal = 0); //Als de cv niet moet op staan zet dan het aantal op nul
    return aantal;                  //Geef het aantal warmte vraag terug
     }
     
 //-----------------------------------------------------------------
 //-------Functie voor positie bepaling voor de servo motor---------
 //-----------------------------------------------------------------
 void servoposition (int aantalwarmtevraag, float stooklijn){
     float graden = -105 + (aantalwarmtevraag * 40);        //-105 is het nulpunt van de servo, zet de servo bij elke warmte vraag 40° meer open
      graden = graden + (stooklijn * 25);                   //Pas de positie van de servo aan de huidige stooklijn
      if (graden >= 90) (graden = 90);                      //Als het resultaat groter wordt stuur dan de servo helmaal open (dit zorgt er voor dat de servo niet vast loopt)
      if (aantalwarmtevraag == 0) (graden = -105);          //Als er geen warmte vraag is zet dan de servo volledig toe
      if (stooklijn <= 0.09) (graden = -105);               //Als de stooklijn 0 is zet dan de servo helemaal toe
      myservo.position(graden);                             //Schrijf de positie naar de servo motor  
     }
     
 //*****************************************************************
 //*******************************Main******************************
 //*****************************************************************
int main() {

lcd.cls();                      //Clear het LCD
lcd.locate(0,0);                //Ga naar positie 0 op de eerste lijn
lcd.printf("Welkom");           //Geef een welkomsboodschap weer op het LCD
lcd.locate(0,1);                //Ga naar positie 0 op de 2de lijn
lcd.printf("Initialiseren");    //Geef 'Initialiseren' weer op het LCD
      
myservo.calibrate(0.0009, 105); //Geef het middenpunt van de servo aan (servo is niet 100% gecentreerd daarom 105°)

//**************************************************
//--------------Initaliseer websocket---------------
//**************************************************
char json_str[1000];                                                    //Maak een buffer aan voor de te verzenden karakters
 
    EthernetInterface eth;                                              //Declareer de ethernet interface
    eth.init();                                                         //Use DHCP ip
    eth.connect();                                                      //Maak conectie met het gekregen ip adress
    
    Websocket ws("ws://sockets.mbed.org:443/ws/ProjectEmbeddedC/wo");   //Wijs een mbed server toe (write only)
    ws.connect();                                                       //Connectie maken met de mbed server
    wait(2.0);                                                          //Wacht even totodat de mbed conectie heeft gemaakt met de mbed server


int timer = 0;              //Maak een lokale variabele aan die de tijdbasis vormt voor het hele programma
int timerweb = 0;           //Maak een lokale variabele aan die de tijdbasis vormt voor data te versturen naar de websocket
  
    while(1) {              //Ga in een eeuwige lus
          
timer = timer + 1;          //Incrementeer de hoofdtimer met 1
if (timer >= 250){          //Wanneer de timer groter of gelijk is aan 250 worden de instructies uitgevoerd, dit is de refresh time van het programma en ook de debounce time (+- 250ms)
timer = 0;                  //Clear de timer terug voor de volgende cyclus 
 
 timerweb = timerweb + 1;   //Incrementeer de webtimer met 1
 if (timerweb >= 20){       //Wanneer deze timer groter of gelijk is aan 20 wordt de data naar de websocket verzonden (+-5 seconden)
    timerweb = 0;           //Clear de webtimer terug voor de volgende cyclus
    
    //Data verzenden naar de webssocket
    sprintf(json_str,"------------------------------------------------------------------- \r\n ");
    ws.send(json_str);
    sprintf(json_str, "Starttijd: %.2D:%.2D:%.2D \r\n        Stoptijd: %.2D:%.2D:%.2D \r\n",startuur,startmin,startsec,stopuur,stopmin,stopsec);
    ws.send(json_str);
    sprintf(json_str, "Hysteresis: %.1f °C \r\n",hysteresis);
    ws.send(json_str);
    sprintf(json_str, "Huidige stooklijn: %.1f °C/uur \r\n",stooklijn);
    ws.send(json_str);
    sprintf(json_str, "Huidige buiten temperatuur: %.1f °C \r\n ",LMTemp_4);
    ws.send(json_str);
    sprintf(json_str, "Huidige temperuur slaapkamer: %.1f °C \r\n        Gewenst %.1f °C \r\n ",LMTemp_3,instelslaap);
    ws.send(json_str);
    sprintf(json_str, "Huidige temperuur keuken: %.1f °C \r\n        Gewenst %.1f °C \r\n ",LMTemp_2,instelkeuken);
    ws.send(json_str);
    sprintf(json_str, "Huidige temperuur living: %.1f °C \r\n        Gewenst %.1f °C \r\n ",LMTemp_1,instelliving);
    ws.send(json_str);
    sprintf(json_str, "%s %.2D-%.2D-%.2D %.2D:%.2D:%.2D \r\n ",dagen(dag),datum,maand,jaar,uur,min,sec);
    ws.send(json_str);
    }
    
my1307.gettime( &sec, &min, &uur, &dag, &datum, &maand, &jaar);     //Lees de tijd uit de DS1307 en plaats elk element in een apparte variabele
    
LMTemp_1 = LM35(1);                     //Lees de temperatuur uit van de living
LMTemp_2 = LM35(2);                     //Lees de temperatuur uit van de keuken
LMTemp_3 = LM35(3);                     //Lees de temperatuur uit van de slaapkamer
LMTemp_4 = LM35(4);                     //Lees de temperatuur uit van buiten
        
        if (SW_1 == true){              //Als er op toets 1 word gedrukt...
            menu = menu + 1;            //Scrol naar boven door het menu
            if (menu > 11) (menu = 0);  //Als alle menu's zijn doorlopen ga dan terug naar het eerste menu
        }
            
        if (SW_2 == true){              //Als er op toets 2 word gedrukt...
            menu = menu - 1;            //Scrol naar beneden door het menu
            if (menu < 0) (menu = 11);  //Als men voorbij het eerste menu wilt gaan begin laat dan het laatste menu terug zien
        }
        
       if (menu == 0){                                                  //Wanneer menu 0 is geselecteerd...
       lcd.cls();                                                       //Clear het LCD
       lcd.locate(4,0);                                                 //Zet de cursor op positie 4 op de eerste lijn
       lcd.printf("%.2D:%.2D:%.2D",uur,min,sec);                        //Print de tijd naar het LCD
       lcd.locate(3,1);                                                 //Zet de cursor op positie 3 op de 2de lijn
       lcd.printf("%s %.2D-%.2D-%.2D",dagen(dag),datum,maand,jaar);     //Print de dag en datum op het LCD
       wijzigmenustop = 0;                                              //Zorg er voor als men uit menu 10 komt dat de ingestelde starttijd word opgeslagen
       }
        
       else if (menu == 1){                     //Wanneer menu 1 is geselecteerd...
       lcd.cls();                               //Clear het LCD
       lcd.locate(0,0);                         //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Temperatuur");               //Print het woord "Temperatuur" naar het LCD
       lcd.locate(0,1);                         //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Living: %.1f C",LMTemp_1);   //Print de temperatuur van de living naar het LCD
       }
       
       else if (menu == 2){                     //Wanneer menu 2 is geselecteerd...
       lcd.cls();                               //Clear het LCD
       lcd.locate(0,0);                         //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Temperatuur");               //Print het woord "Temperatuur" naar het LCD
       lcd.locate(0,1);                         //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Keuken: %.1f C",LMTemp_2);   //Print de temperatuur van de keuken naar het LCD
       }
       
        else if (menu == 3){                    //Wanneer menu 3 is geselecteerd...
       lcd.cls();                               //Clear het LCD
       lcd.locate(0,0);                         //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Temperatuur");               //Print het woord "Temperatuur" naar het LCD
       lcd.locate(0,1);                         //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Slaap: %.1f C",LMTemp_3);    //Print de temperatuur van de slaapkamer naar het LCD
       }
       
       else if (menu == 4){                     //Wanneer menu 4 is geselecteerd...
       lcd.cls();                               //Clear het LCD
       lcd.locate(0,0);                         //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Temperatuur");               //Print het woord "Temperatuur" naar het LCD
       lcd.locate(0,1);                         //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Buiten: %.1f C",LMTemp_4);   //Print de temperatuur van buiten naar het LCD
       }
       
       else if (menu == 5){                         //Wanneer menu 5 is geselecteerd...
       lcd.cls();                                   //Clear het LCD
       lcd.locate(0,0);                             //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Gewenste temp");                 //Print het woorden "Gewenste temp" naar het LCD
       lcd.locate(0,1);                             //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Living: %.1f C",instelliving);   //Print de huidige gewenste temperatuur van de living naar het LCD
            
            if (SW_3 == true & instelliving < 30) (instelliving = instelliving + 0.1);  //Wanneer er op switch 3 wordt geduwt verhoog de gewenste temperatuur met 0.1
            if (SW_4 == true & instelliving > 0) (instelliving = instelliving - 0.1);   //Wanneer er op switch 4 wordt geduwt verlaag de gewenste temperatuur met 0.1
       }
       
       else if (menu == 6){                         //Wanneer menu 6 is geselecteerd...
       lcd.cls();                                   //Clear het LCD
       lcd.locate(0,0);                             //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Gewenste temp");                 //Print het woorden "Gewenste temp" naar het LCD
       lcd.locate(0,1);                             //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Keuken: %.1f C",instelkeuken);   //Print de huidige gewenste temperatuur van de keuken naar het LCD
            
            if (SW_3 == true & instelkeuken < 30) (instelkeuken = instelkeuken + 0.1);  //Wanneer er op switch 3 wordt geduwt verhoog de gewenste temperatuur met 0.1
            if (SW_4 == true & instelkeuken > 0) (instelkeuken = instelkeuken - 0.1);   //Wanneer er op switch 4 wordt geduwt verlaag de gewenste temperatuur met 0.1
       }
       
       else if (menu == 7){                         //Wanneer menu 7 is geselecteerd...
       lcd.cls();                                   //Clear het LCD
       lcd.locate(0,0);                             //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Gewenste temp");                 //Print het woorden "Gewenste temp" naar het LCD
       lcd.locate(0,1);                             //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("Slaap: %.1f C",instelslaap);     //Print de huidige gewenste temperatuur van de slaapkamer naar het LCD
            
            if (SW_3 == true & instelslaap < 30) (instelslaap = instelslaap + 0.1); //Wanneer er op switch 3 wordt geduwt verhoog de gewenste temperatuur met 0.1
            if (SW_4 == true & instelslaap > 0) (instelslaap = instelslaap - 0.1);  //Wanneer er op switch 4 wordt geduwt verlaag de gewenste temperatuur met 0.1
       }
       
       else if (menu == 8){                         //Wanneer menu 8 is geselecteerd...
       lcd.cls();                                   //Clear het LCD
       lcd.locate(0,0);                             //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Stooklijn");                     //Print het woord "Stooklijn" naar het LCD
       lcd.locate(0,1);                             //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("%.1f C/uur",stooklijn);          //Print de huidige stooklijn naar het LCD
       wijzigmenustart = 0;                         //Zorg er voor als er uit menu 9 wordt teruggekeerd dat de ingestelde starttijd word opgeslagen
       }
       
       else if (menu == 9){                         //Wanneer menu 9 is geselecteerd...
       lcd.cls();                                   //Clear het LCD
       lcd.locate(0,0);                             //Zet de cursor op positie 0 op de eerste lijn
       lcd.printf("Hysteresis");                    //Print het woord "Hysteresis" naar het LCD
       lcd.locate(0,1);                             //Zet de cursor op positie 0 op de 2de lijn
       lcd.printf("%.1f C",hysteresis);             //Print de huidige hysteresis naar het LCD
       wijzigmenustart = 0;                         //Zorg er voor als er uit menu 9 wordt teruggekeerd dat de ingestelde starttijd word opgeslagen
       
       if (SW_3 == true & hysteresis < 5) (hysteresis = hysteresis + 0.1);  //Wanneer er op switch 3 wordt geduwt verhoog de hysteresis met 0.1
       if (SW_4 == true & hysteresis > 0) (hysteresis = hysteresis - 0.1);  //Wanneer er op switch 4 wordt geduwt verlaag de hysteresis met 0.1
       }
//----------------Menu 10--------------------------------     
       else if (menu == 10){                                                    //Wanneer menu 10 is geselecteerd...
           lcd.cls();                                                           //Clear het LCD
           lcd.locate(0,0);                                                     //Zet de cursor op positie 0 op de eerste lijn
           lcd.printf("Starttijd");                                             //Print het woord "Startijd" steeds naar het LCD
               if (wijzigmenustart == 0 | flikertimer >= 3){                    //Waneer er geen wijzing wordt uitgevoerd of de flikertimer overflowd...
               lcd.locate(0,1);                                                 //Zet de cursor op positie 0 op de 2de lijn
               lcd.printf("%.2D:%.2D:%.2D",startuur,startmin,startsec);         //Print alle elemeneten van de startijd naar het LCD
               }
               
            timerwijzigen = timerwijzigen + 1;                                  //Incrementeer de timerwijzigen met 1 (tijdbasis voor het indrukken van beide knoppen)
                if (!(SW_3 == true && SW_4 == true & 1)) (timerwijzigen = 0);   //Wanneer beide knopen tergelijkertijd worden ingedrukt wordt de timerwijzigen NIET gecleard
            if (timerwijzigen == 3)(wijzigmenustart = wijzigmenustart + 1);     //Wanneer de timerwijzigen gelijk is aan 3 en dus beide knopen +- 750ms zijn ingedrukt, incrementeer de wijzig meneu met 1
            if (wijzigmenustart > 3) (wijzigmenustart = 0);                     //Wanneer de menu meer als 3 wordt wordt deze terug op 0 gezet
         
            if (wijzigmenustart == 1){                          //Wanneer de wijzigmenustart gelijk is aan 1...
            flikertimer = flikertimer + 1;                      //Incrementeer de flikertimer met 1
                if (flikertimer <= 4) {                         //Wanneer de flikertimer kleiner of gelijk is aan 4...
                lcd.locate(0,0);                                //Zet de cursor op positie 0 op de eerste lijn
                lcd.printf("Starttijd");                        //Print het woord "Startijd" steeds naar het LCD
                lcd.locate(0,1);                                //Zet de cursor op positie 0 op de 2de lijn
                lcd.printf("  :%.2D:%.2D",startmin,startsec);   //Print de elemeneten startmin en startsec van de startijd naar het LCD
                }
                
                if (flikertimer > 4) (flikertimer = 0);         //Clear de flikkertimer wanneer hij groter wordt dan 4
                           
            if (SW_3 == true) (startuur = startuur + 1);        //Wanneer er op switch 3 wordt geduwt verhoog het start uur met 0.1
            if (SW_4 == true) (startuur = startuur - 1);        //Wanneer er op switch 4 wordt geduwt verlaag het start uur met 0.1
            if (startuur > 23) (startuur = 0);                  //Wanneer het start uur groter wordt dan 23 uur, zet het dan terug op 0
            if (startuur < 0) (startuur = 23);                  //Wanneer het start uur kleiner wordt dan 0 uur, zet het dan terug op 23
            }
            
            if (wijzigmenustart == 2){                          //Wanneer de wijzigmenustart gelijk is aan 2...
            flikertimer = flikertimer + 1;                      //Incrementeer de flikertimer met 1
                if (flikertimer <= 4) {                         //Wanneer de flikertimer kleiner of gelijk is aan 4...
                lcd.locate(0,0);                                //Zet de cursor op positie 0 op de eerste lijn
                lcd.printf("Starttijd");                        //Print het woord "Startijd" steeds naar het LCD
                lcd.locate(0,1);                                //Zet de cursor op positie 0 op de 2de lijn
                lcd.printf("%.2D:  :%.2D",startuur,startsec);   //Print de elemeneten startuur en startsec van de startijd naar het LCD
                }
                
                if (flikertimer > 4) (flikertimer = 0);         //Clear de flikkertimer wanneer hij groter wordt dan 4
                            
            if (SW_3 == true) (startmin = startmin + 1);        //Wanneer er op switch 3 wordt geduwt verhoog het start min met 0.1
            if (SW_4 == true) (startmin = startmin - 1);        //Wanneer er op switch 4 wordt geduwt verlaag het start min met 0.1
            if (startmin > 59) (startmin = 0);                  //Wanneer het start min groter wordt dan 59 min, zet het dan terug op 0
            if (startmin < 0) (startmin = 59);                  //Wanneer het start min kleiner wordt dan 0 min, zet het dan terug op 59
            }   
                                 
          if (wijzigmenustart == 3){                            //Wanneer de wijzigmenustart gelijk is aan 3...
            flikertimer = flikertimer + 1;                      //Incrementeer de flikertimer met 1
                if (flikertimer <= 4) {                         //Wanneer de flikertimer kleiner of gelijk is aan 4...
                lcd.locate(0,0);                                //Zet de cursor op positie 0 op de eerste lijn
                lcd.printf("Starttijd");                        //Print het woord "Startijd" steeds naar het LCD
                lcd.locate(0,1);                                //Zet de cursor op positie 0 op de 2de lijn
                lcd.printf("%.2D:%.2D:  ",startuur,startmin);   //Print de elemeneten startuur en startmin van de startijd naar het LCD
                }
                
                if (flikertimer > 4) (flikertimer = 0);         //Clear de flikkertimer wanneer hij groter wordt dan 4
                           
            if (SW_3 == true) (startsec = startsec + 1);        //Wanneer er op switch 3 wordt geduwt verhoog het start sec met 0.1
            if (SW_4 == true) (startsec = startsec - 1);        //Wanneer er op switch 4 wordt geduwt verlaag het start sec met 0.1
            if (startsec > 59) (startsec = 0);                  //Wanneer het start sec groter wordt dan 59 sec, zet het dan terug op 0
            if (startsec < 0) (startsec = 59);                  //Wanneer het start sec kleiner wordt dan 0 sec, zet het dan terug op 59
            }
            wijzigmenustop = 0;                                 //Zorg er voor als er uit menu 10 wordt teruggekeerd dat de ingestelde stoptijd word opgeslagen
    }
//---------------------------- Menu 11---------------------------------       
       else if (menu == 11){                                                    //Wanneer menu 11 is geselecteerd...
           lcd.cls();                                                           //Clear het LCD
           lcd.locate(0,0);                                                     //Zet de cursor op positie 0 op de eerste lijn
           lcd.printf("Stoptijd");                                              //Print het woord "Stoptijd" steeds naar het LCD
               if (wijzigmenustop == 0 | flikertimer >= 3){                     //Waneer er geen wijzing wordt uitgevoerd of de flikertimer overflowd...
               lcd.locate(0,1);                                                 //Zet de cursor op positie 0 op de 2de lijn
               lcd.printf("%.2D:%.2D:%.2D",stopuur,stopmin,stopsec);            //Print alle elemeneten van de stoptijd naar het LCD
               }
               
            timerwijzigen = timerwijzigen + 1;                                  //Incrementeer de timerwijzigen met 1 (tijdbasis voor het indrukken van beide knoppen)   
                if (!(SW_3 == true && SW_4 == true & 1)) (timerwijzigen = 0);   //Wanneer beide knopen tergelijkertijd worden ingedrukt wordt de timerwijzigen NIET gecleard
            if (timerwijzigen == 3)(wijzigmenustop = wijzigmenustop + 1);       //Wanneer de timerwijzigen gelijk is aan 3 en dus beide knopen +- 750ms zijn ingedrukt, incrementeer de wijzig meneu met 1
            if (wijzigmenustop > 3) (wijzigmenustop = 0);                       //Wanneer de menu meer als 3 wordt wordt deze terug op 0 gezet
         
            if (wijzigmenustop == 1){                           //Wanneer de wijzigmenustart gelijk is aan 1...
            flikertimer = flikertimer + 1;                      //Incrementeer de flikertimer met 1
                if (flikertimer <= 4) {                         //Wanneer de flikertimer kleiner of gelijk is aan 4...
                lcd.locate(0,0);                                //Zet de cursor op positie 0 op de eerste lijn
                lcd.printf("Stoptijd");                         //Print het woord "Stoptijd" steeds naar het LCD
                lcd.locate(0,1);                                //Zet de cursor op positie 0 op de 2de lijn
                lcd.printf("  :%.2D:%.2D",stopmin,stopsec);     //Print de elemeneten stopmin en stopsec van de stoptijd naar het LCD
                }
                
                if (flikertimer > 4) (flikertimer = 0);         //Clear de flikkertimer wanneer hij groter wordt dan 4
                             
            if (SW_3 == true) (stopuur = stopuur + 1);          //Wanneer er op switch 3 wordt geduwt verhoog het stop uur met 0.1
            if (SW_4 == true) (stopuur = stopuur - 1);          //Wanneer er op switch 4 wordt geduwt verlaag het stop uur met 0.1
            if (stopuur > 23) (stopuur = 0);                    //Wanneer het stop uur groter wordt dan 23 uur, zet het dan terug op 0
            if (stopuur < 0) (stopuur = 23);                    //Wanneer het stop uur kleiner wordt dan 0 uur, zet het dan terug op 23
            }
            
            if (wijzigmenustop == 2){                           //Wanneer de wijzigmenustart gelijk is aan 2...
            flikertimer = flikertimer + 1;                      //Incrementeer de flikertimer met 1
                if (flikertimer <= 4) {                         //Wanneer de flikertimer kleiner of gelijk is aan 4...
                lcd.locate(0,0);                                //Zet de cursor op positie 0 op de eerste lijn
                lcd.printf("Stoptijd");                         //Print het woord "Stoptijd" steeds naar het LCD
                lcd.locate(0,1);                                //Zet de cursor op positie 0 op de 2de lijn
                lcd.printf("%.2D:  :%.2D",stopuur,stopsec);     //Print de elemeneten stopuur en stopsec van de stoptijd naar het LCD
                }
                
                if (flikertimer > 4) (flikertimer = 0);         //Clear de flikkertimer wanneer hij groter wordt dan 4
                        
            if (SW_3 == true) (stopmin = stopmin + 1);          //Wanneer er op switch 3 wordt geduwt verhoog het stop min met 0.1
            if (SW_4 == true) (stopmin = stopmin - 1);          //Wanneer er op switch 4 wordt geduwt verlaag het stop min met 0.1
            if (stopmin > 59) (stopmin = 0);                    //Wanneer het stop min groter wordt dan 59 min, zet het dan terug op 0
            if (stopmin < 0) (stopmin = 59);                    //Wanneer het stop min kleiner wordt dan 0 min, zet het dan terug op 59
            }  
                                  
          if (wijzigmenustop == 3){                             //Wanneer de wijzigmenustart gelijk is aan 3...
            flikertimer = flikertimer + 1;                      //Incrementeer de flikertimer met 1
                if (flikertimer <= 4) {                         //Wanneer de flikertimer kleiner of gelijk is aan 4...
                lcd.locate(0,0);                                //Zet de cursor op positie 0 op de eerste lijn
                lcd.printf("Stoptijd");                         //Print het woord "Stoptijd" steeds naar het LCD
                lcd.locate(0,1);                                //Zet de cursor op positie 0 op de 2de lijn
                lcd.printf("%.2D:%.2D:  ",stopuur,stopmin);     //Print de elemeneten stopuur en stopmin van de stoptijd naar het LCD
                }
                
                if (flikertimer > 4) (flikertimer = 0);         //Clear de flikkertimer wanneer hij groter wordt dan 4
                           
            if (SW_3 == true) (stopsec = stopsec + 1);          //Wanneer er op switch 3 wordt geduwt verhoog het stop sec met 0.1
            if (SW_4 == true) (stopsec = stopsec - 1);          //Wanneer er op switch 4 wordt geduwt verlaag het stop sec met 0.1
            if (stopsec > 59) (stopsec = 0);                    //Wanneer het stop sec groter wordt dan 59 sec, zet het dan terug op 0
            if (stopsec <= 0) (stopsec = 59);                   //Wanneer het stop sec kleiner wordt dan 0 sec, zet het dan terug op 59
            }
            wijzigmenustart = 0;                                //Zorg er voor als men uit menu 10 komt dat de ingestelde starttijd word opgeslagen
    }      
//-------------------------------------------------------------------
}
     //Gegevens die steeds worden opgevraagt
     stooklijn = stooklijnfunctie(stooklijn);                   //Kijk of er een nieuwe stooklijn is, dit doet men met de functie "stooklijnfunctie" en men geeft de huidige stooklijn mee met de functie
     onoff(aantalwarmtevraag());                                //Stuur de relais en de RBG led aan afhankelijk van de warmtevraag, dit wordt gedaan met de functie "onoff" en men geeft de functie "aantalwarmtevraag" mee als variabele
     servoposition(aantalwarmtevraag(),stooklijn);              //Pas de hoek van de servo aan aan de huidige situatie, dit doet men met de functie "servoposition" men geeft de functie "aantalwarmtevraag" mee als variabele als ook de huidige stooklijn
     wait(0.001);                                               //Geef een kleine wacht tijd op zodat de processor niet op volle kracht meot werken, deze tijd bepaalt de snelheid van heel het programma
    }
}

