#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "math.h" 

//Define objects
AnalogIn    emg( A0 );
AnalogIn    emg1( A1 );
//AnalogIn    emg2( A2 );
//AnalogIn    emg3( A3 );

Ticker      sample_timer;
HIDScope    scope( 2 );
DigitalOut  led(LED1);

int P= 200;
int Q = 200;
double A[200];
double B[200];

BiQuadChain bqcR;
BiQuad bq1R( 0.6844323315947305,1.368864663189461, 0.6844323315947305,1.2243497755555954,0.5133795508233265);
BiQuad bq2R( 0.6844323315947306, -1.3688646631894612,  0.6844323315947306,   -1.2243497755555959, 0.5133795508233266);
BiQuad bq3R(  0.7566897754116633, -1.2243497755555959,  0.7566897754116633,   -1.2243497755555959, 0.5133795508233266);
BiQuadChain bqcL;
BiQuad bq1L( 0.6844323315947305,1.368864663189461, 0.6844323315947305,1.2243497755555954,0.5133795508233265);
BiQuad bq2L( 0.6844323315947306, -1.3688646631894612,  0.6844323315947306,   -1.2243497755555959, 0.5133795508233266);
BiQuad bq3L(  0.7566897754116633, -1.2243497755555959,  0.7566897754116633,   -1.2243497755555959, 0.5133795508233266);

void emgSample() {
    
    double emgFilteredR = bqcR.step( emg.read() );
    double emgabsR = abs(emgFilteredR);
    //scope.set(0, emgFiltered );
    //scope.set(1, emgabs );
    
    for(int i = P-1; i >= 0; i--){
        if (i == 0) {
            A[i] = emgabsR;
            }
         else {
             A[i] = A[i-1];
             }   
        }
    
     double sumR = 0;
    for (int n = 0; n < P-1; n++) {
    sumR = sumR + A[n];
    }
    
    double movmeanR = sumR/P;
    
    scope.set(0, movmeanR);
    
    double emgFilteredL = bqcL.step( emg1.read() );
    double emgabsL = abs(emgFilteredL);
       
    for(int i = Q-1; i >= 0; i--){
        if (i == 0) {
            B[i] = emgabsL;
            }
         else {
             B[i] = B[i-1];
             }   
        }
    
     double sumL = 0;
    for (int n = 0; n < Q-1; n++) {
    sumL = sumL + B[n];
    }
    
    double movmeanL = sumL/Q;
    
    scope.set(1, movmeanL);
    
    scope.send();
    
}
int main()
{
    bqcR.add( &bq1R ).add( &bq2R ).add( &bq3R );
    bqcL.add( &bq1L ).add( &bq2L ).add( &bq3L );
    sample_timer.attach( &emgSample, 0.002 );
    while(1) {}
}