#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "math.h" 


//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 3 );
DigitalOut  led(LED1);

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
 int P= 200;
 double A[200];
 
 
void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

BiQuadChain bqc;
BiQuad bq1( 0.6844323315947305,1.368864663189461, 0.6844323315947305,1.2243497755555954,0.5133795508233265);
BiQuad bq2( 0.6844323315947306, -1.3688646631894612,  0.6844323315947306,   -1.2243497755555959, 0.5133795508233266);
BiQuad bq3(  0.7566897754116633, -1.2243497755555959,  0.7566897754116633,   -1.2243497755555959, 0.5133795508233266);

Ticker emgSampleTicker;
AnalogIn emg( A0 );

void emgSample() {
    
    double emgFiltered = bqc.step( emg.read() );
    double emgabs = abs(emgFiltered);
    scope.set(0, emgFiltered );
    scope.set(1, emgabs );
    
    for(int i = P-1; i >= 0; i--){
        if (i == 0) {
            A[i] = emgabs;
            }
         else {
             A[i] = A[i-1];
             }   
        }
    double sum = 0;
    for (int n = 0; n < P-1; n++) {
    sum = sum + A[n];
    }
    
    double movmean = sum/P;
    
    scope.set(2, movmean);
    scope.send();
}


int main()
{   
bqc.add( &bq1 ).add( &bq2 ).add( &bq3 );
emgSampleTicker.attach( &emgSample, 0.002 );
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    //sample_timer.attach(&sample, 0.01);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}