#include "adi_sense_1000_lut_data.h"
#include "adi_sense_1000_sensor_types.h"

/*
 * The following example illustrates how individual tables can be declared, and
 * later assembled into a complete LUT data structure using
 * adi_sense_1000_AssembleLutData().  That LUT data structure can then be
 * written to the ADI Sense 1000 device using adi_sense_1000_SetLutData().
 */


/*
 * The following table provide linearisation data for a 4-wire bridge sensor
 * identified with the ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2
 * sensor type.  The Look-Up Table provided maps a range of input (X)
 * values to a corresponding range of output (Y) values.  In this example,
 * the bridge sensor input in millivolts is effectively translated to volts.
 */
 ADI_SENSE_1000_LUT_DESCRIPTOR lc0 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc0Data = {
    .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        3.852f,
        5.42f,
        6.71f,
        9.61f,
        12.67f,
        16.29f,
        19.6f,
        +3300.0f, /* x(max) */
       -0.0001f,    /* y(min) */
        0.00f,
        2.5f,
        5.00f,
        7.5f,
        10.00f,
        12.5,
        15.00f,
        +50.0f,    /* y(max) */
    },
};

 
ADI_SENSE_1000_LUT_DESCRIPTOR lc1 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc1Data = {
            .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        -4.45f,
        -2.42f,
        1.08f,
        7.52f,
        12.15f,
        18.33f,
        23.93f,
        +3300.0f, /* x(max) */
       -0.0001f,    /* y(min) */
        0.00f,
        2.5f,
        5.00f,
        7.5f,
        10.00f,
        12.5,
        15.00f,
        +50.0f,    /* y(max) */
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR lc2 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_3_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc2Data = {
    .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        0.097f,
        2.03f,
        4.45f,
        6.95f,
        9.49f,
        14.02f,
        18.73f,
        +3300.0f, /* x(max) */
        -0.000001f,    /* y(min) */
        0.00f,
        2.51f,
        5.00f,
        7.5f,
        10.0f,
        12.5f,
        15.0f,
        +50.0f, 
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR lc3 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_4_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc3Data = {
     .nElements = 9,
    .lut = {
       -3300.0f, /* x(min) */
        3.129f,
        5.75f,
        9.43f,
        13.31f,
        17.18f,
        21.04f,
        24.77f,
        +3300.0f, /* x(max) */
        -0.000001f,    /* y(min) */
        0.00f,
        2.641f,
        5.07f,
        7.5f,
        10.0f,
        12.5f,
        15.0f,
        +50.0f, 

    },
};


/*
 * The following variables can be passed as parameters to
 * adi_sense_1000_AssembleLutData()
 */
ADI_SENSE_1000_LUT_DESCRIPTOR *sample_lut_desc_list[] = {
    &lc0,
   /* &lc1,
    &lc2,
    &lc3,   */

};

ADI_SENSE_1000_LUT_TABLE_DATA *sample_lut_data_list[] = {
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc0Data,
   /* (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc1Data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc2Data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc3Data, */
};

unsigned sample_lut_num_tables =
    (sizeof(sample_lut_desc_list) / sizeof(sample_lut_desc_list[0]));

