#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"

//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 2 );
DigitalOut  led(LED1);

BiQuadChain bqc;
BiQuad bq1(0.0030, 0.0059, 0.0030, -1.8404,0.8522); //voor low-pass
BiQuad bq2(0.9737, -1.9474, 0.9737, -1.9467, 0.9481); //voor high-pass
BiQuad bq3(0.9912, -1.9823,0.9912, -1.9822, 0.9824); //lage piek eruit-> voor coëfficienten, zie matlab

Ticker emgSampleTicker;
AnalogIn emg(A0); //kloptA0 wel??

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}





void emgSample()
{   
    double emgFiltered=bqc.step(emg.read());
}


int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    sample_timer.attach(&sample, 0.002f);
    bqc.add(&bq1).add(&bq2).add(&bq3);
    emgSampleTicker.attach(&emgSample,0.01);

    /*empty loop, sample() is executed periodically*/
    while(1) {
        wait(0.1f);
        }
}