#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "MovingAverage.h"
#include "MODSERIAL.h"
#include "math.h"
#define NSAMPLE 200

//Define objects
AnalogIn    emg0( A0 ); //Biceps Left
AnalogIn    emg1( A1 ); //Biceps Right
Ticker      sample_timer;
InterruptIn button(PTC6);

//Ticker      driving_timer;
HIDScope    scope( 4 ); //Number of Channels
DigitalOut  led1(LED_RED);
DigitalOut  led2(LED_GREEN);
DigitalOut  led3(LED_BLUE);
MovingAverage <double>Movag_LB(NSAMPLE,0.0); //Make Moving Average, Define NSAMPLE above
MovingAverage <double>Movag_RB(NSAMPLE,0.0);
volatile double LB_Out;
volatile double RB_Out;

MODSERIAL pc(USBTX, USBRX);

//Make Biquad filters Left(a0, a1, a2, b1, b2)
BiQuadChain bqc1; //chain voor High Pass en Notch
BiQuad bq1(0.39131200825291007, -0.7826240165058201, 0.39131200825291007, -0.36950493743858204, 0.1957430955730582); //High Pass Filter
BiQuad bq2(9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01); //Notch Filter
//BiQuad bq3(0.00044924972004654657, 0.0008984994400930931, 0.00044924972004654657, -1.6169385656964415, 0.6187355645766276); //Low Pass Filter

//Make Biquad filters Right
BiQuadChain bqc2; //chain voor High Pass en Notch
BiQuad bq4(0.39131200825291007, -0.7826240165058201, 0.39131200825291007, -0.36950493743858204, 0.1957430955730582); //High Pass Filter
BiQuad bq5(9.91104e-01, -1.60364e+00, 9.91104e-01, -1.60364e+00, 9.82207e-01); //Notch Filter

volatile double MaxLeft = 0.0;
volatile double MaxRight = 0.0;
volatile double ThresholdLeft = 0.0;
volatile double ThresholdRight = 0.0;

//Function to read samples and filter and send to HIDScope
void sample()
{
    //Filter Left Bicep
    double LB_Filter_1 = bqc1.step(emg0.read()); //High Pass + Notch
    double LB_Rectify = fabs(LB_Filter_1); //Rectify Signal
    //double Filtered_emg_1 = bq3.step(LB_Rectify); //Low Pass
    Movag_LB.Insert(LB_Rectify);
    LB_Out = Movag_LB.GetAverage();

    //Filter Right Bicep
    double RB_Filter_1 = bqc2.step(emg1.read()); //High Pass + Notch
    double RB_Rectify = fabs(RB_Filter_1); //Rectify Signal
    //double Filtered_emg_1 = bq3.step(RB_Rectify); //Low Pass
    Movag_RB.Insert(RB_Rectify);
    RB_Out = Movag_RB.GetAverage();

    scope.set(0, emg0.read() ); //Raw EMG signal left bicep
    scope.set(1, LB_Out); // Filtered EMG signal left bicep
    scope.set(2, emg1.read()); //Raw EMG signal  right bicep
    scope.set(3, RB_Out); //Filtered EMG signal right bicep

    scope.send();

    if(LB_Out > MaxLeft) {
        MaxLeft = LB_Out;
        led2 = 0;
    }
    else {
        led2 = 1;
    }
    if(RB_Out > MaxRight) {
        MaxRight = RB_Out;
        led3 = 0;
        }
    else {
        led3 = 1;
    }
    ThresholdLeft = abs(0.15000*MaxLeft);
    ThresholdRight = abs(0.15000*MaxRight);

}

void PrintThreshold()
{
    pc.baud(115200);
    pc.printf("left: %.3f  threshold : %.3f\r\n right: %.3f  threshold : %.3f\r\n ",MaxLeft, ThresholdLeft,MaxRight,ThresholdRight);
}


int main()
{
    bqc1.add( &bq1 ).add( &bq2 ); //make BiQuadChain
    bqc2.add( &bq4 ).add( &bq5 ); //make BiQuadChain
    sample_timer.attach(&sample, 0.002); //read samples at 500 Hz
    button.fall(&PrintThreshold);
    while(1) {}
}

