
/*
 * Write a variable into a led bus
 *
 * Connections:
 *
 * PA_5 --- led0
 * PA_6 --- led1
 * PA_7 --- led2
 * PB_6 --- led3
 * PC_7 --- led4
 * PA_9 --- led5
 * PA_8 --- led6
 * PB_10 --- led8
 *
 */

#include "mbed.h"
#include "Hotboards_leds.h"

//Creates a bus with 8 leds
//                 bit 7   bit 6  bit 5  bit 4  bit 3  bit 2  bit 1  bit 0
Hotboards_leds leds( PB_10 , PA_8 , PA_9 , PC_7 , PB_6 , PA_7 , PA_6 , PA_5 );

uint8_t counter;

int main()
{
    counter = 0;
    while(1)
    {
        //Shows on the led bus the counter variable value
        leds.write( counter );
        wait_ms( 500 );
        counter ++;
        //We can still manipulate each led individually with
        //the functions turnOn, turnOff, toggle, write, but in
        //this case the function will need a parameter indicating
        //the led you want to manipulate
        //Example: leds.turnOn(3) turns ON led #3
    }
}
