
/* Library:     Hotboards_switches.h
 * Project:     inputs
 * File:        main.cpp
 * Author:      Diego Perez
 * Modified by: Roman Valencia 
 * Contact:     http://www.hotboards.org/
 *
 * Read the value from 4 sw's (dip switch) and also read the value from a single sw.
 */
 
#include "mbed.h"
#include "Hotboards_switches.h"

// Creates two sw objects, this interrupt will give us a LOW(0) value when close
// because our dip switch works with pull-ups.
Hotboards_switches dip1( PA_9 , PA_8 , PB_10 , PB_4 );
Hotboards_switches sw1( PA_6 );
// If your dip switch will gave you a HIGH(1) value when close, then we need to create
// the sw object with an extra parameter: 
// Hotboards_switches dip1( PA_9 , PA_8 , PB_10 , PB_4 , 1 );
// Hotboards_swtiches sw1( PA_6 , 1 );
// In any case the function will return a HIGH(1) value any time the sw is closed

//For this example we will use the USB serial port, here we initialize it
Serial pc(USBTX,USBRX);

int i, j;
uint8_t binary, decimal;

int main()
{
    while(1)
    {
        //Asks for the state of the sw1
        if( sw1.read( ) )
        {
            pc.printf( "sw1     = close (on)\r" );
        }
        else
        {
            pc.printf( "sw1     = open (off)\r" );
        }
        //Asks for the state of an specific sw from the dip switch dip1
        if( dip1.read( 2 ) )
        {
            pc.printf( "dip sw2 = close (on)\r" );
        }
        else
        {
            pc.printf( "dip sw2 = open (off)\r" );
        }
        
        // Reads the dip switch value and puts it in binary
        binary = dip1.read();
        // Inverts the read value to make it coincide with the state of each
        // switch in binary
        binary = ~binary;
        // Applies a mask(00001111) to extract the value of the dip switch
        decimal = binary&0x0F;
        // Sends throught USB serial the value in decimal
        pc.printf( "dec     = " );
        pc.printf( "%d\r" , decimal );
        // Sends through USB serial the value in binary
        pc.printf( "bin     = " );
        for(i=0;i<4;i++)            //Extracts and shows the binary value of each sw
        { 
            j = binary&0x08;        //Applies a mask(00001000) to extract the value of the bit in turn
            j>>=3;                  //Moves this bit 3 positions to the right
            pc.printf("%d",j);      //Sends through USB serial the value of the extracted bit
            binary <<=1;            //Moves the position 1 bit to the left to extract the next bit
        }
        pc.printf( "\n\r" );
        wait( 2 );
    }
}
