
#include "mbed.h"
#include "Hotboards_keypad.h"

// Se define el arreglo keys con su respectivo número de renglones
// y columnas, y con el valor de cada una de las teclas
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Se definen los pines que conectan a las filas
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Se definen los pines que conectan a las columnas
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Se crea un nuevo teclado con los valores anteriores
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Se configura el puerto serial
Serial pc( USBTX , USBRX );


// Esta función se manda a llamar dentro de la función getKey
// cuando una tecla cambia su estado.
void kpdEvent( KeypadEvent key )
{
    // Se pide el estado de la tecla activa
    switch( kpd.getState( ) )
    {
        case PRESSED: // Se presionó
            pc.printf( "%c\t" , key );
            pc.printf( "PRESSED\n\r" );
            break;
        case RELEASED: // Se soltó
            pc.printf( "%c\t" , key );
            pc.printf( "RELEASED\n\r" );
            break;
        case HOLD:     // Está presionada
            pc.printf( "%c\t" , key );
            pc.printf( "HOLD\n\r" );
            break;
    }
}

int main()
{
    // Se agrega la función kpdEvent como evento
    kpd.addEventListener( kpdEvent );
    while(1)
    {
        // Se consulta constantemente para revisar si se presionó
        // una tecla o cambió su estado, esto es necesario para que se
        // llame a la función kdpEvent
        kpd.getKey( );
    }
}
