
#include "mbed.h"
#include "Hotboards_keypad.h"
#include <string>

using std::string;

// Se define el arreglo keys con su respectivo número de renglones
// y columnas, y con el valor de cada una de las teclas
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Se definen los pines que conectan a las filas
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Se definen los pines que conectan a las columnas
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Se crea un nuevo teclado con los valores anteriores
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Se configura el puerto serial
Serial pc( USBTX , USBRX );

int i;

int main()
{
    string msg;
    while(1)
    {
        // Se llenará el arreglo kpd.key[ ] con las teclas que se presionen,
        // y además regresará un (1) si se presionó una o mas teclas.
        if( kpd.getKeys( ) )
        {
            // Se revisa la lista de teclas
            for( i = 0 ; i <= LIST_MAX ; i++ )
            {
                //Se revisa si alguna tecla cambio su estado
                if( kpd.key[ i ].stateChanged )
                {
                    // Se reporta el estado de la tecla activa:
                    // IDLE, PRESSED, HOLD, o RELEASED
                    switch( kpd.key[ i ].kstate )
                    {
                        case PRESSED:
                            msg = " PRESSED. "; // Se presionó
                            break;
                        case HOLD:              // Está presionada
                            msg = " HOLD. ";
                            break;
                        case RELEASED:          // Se soltó
                            msg = " RELEASED. ";
                            break;
                        case IDLE:
                            msg = " IDLE. ";
                            break;
                        default:
                            break;
                    }
                    // Se manda por serial el estado de la tecla presionada
                    pc.printf( "Key " );
                    pc.printf( "%c" , kpd.key[ i ].kchar );
                    pc.printf( "%s" , msg.c_str() );
                    pc.printf( "\n\r" );
                }
            }
        }
    }
}
