
#include "mbed.h"
#include "Hotboards_keypad.h"

// Se define el arreglo keys con su respectivo número de renglones
// y columnas, y con el valor de cada una de las teclas
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Se definen los pines que conectan a las filas
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Se definen los pines que conectan a las columnas
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Se crea un nuevo teclado con los valores anteriores
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Se configura el puerto serial
Serial pc( USBTX , USBRX );

int main()
{
    while(1)
    {
        // Se pregunta por cualquier tecla presionada
        char key = kpd.getKey( );
        
        // Si se presiona una tecla "key" tendrá un valor diferente de cero
        if( key )
        {
            // Se manda al puerto serial la tecla presionada
            pc.printf( "%c" , key );
            pc.printf( "\n\r" );
        }
    }
}
