

#include "mbed.h"


Serial pc( USBTX , USBRX );

class Botonazo
{
    public:
        Botonazo( PinName btn ) : _btn( btn )
        {
        }
        bool isPressed( void )
        {
            int _lastButtonState = 1;
            
            int buttonState;
            bool isPressed = 0;
            //buttonState = _btn.read;
            buttonState = _btn;
            if( buttonState != _lastButtonState )
            {
                if( buttonState == 0 )
                {
                    isPressed = 1;
                }
            }
            _lastButtonState = buttonState;
            return isPressed;
        }
    private:
        DigitalIn _btn;
        //int _lastButtonState = 1;
        
};

Botonazo btn1( PA_6 );
Botonazo btn2( PA_7 );

DigitalOut led1( PA_9 );

unsigned long previousMillis = 0;
bool blink = 0;

Timer timer;

int main()
{
    timer.start();
    while(1)
    {
        if( btn1.isPressed() == 1 )
        {
            blink = 1;
        }
        
        if( btn2.isPressed() == 1 )
        {
            blink = 0;
            led1 = 0;
        }
        
        if( blink == 1)
        {
            unsigned long currentMillis = timer.read_ms();
            
            if( ( currentMillis - previousMillis ) >= 100 )
            {
                previousMillis = currentMillis;
                led1 = !led1;
            }
        }
    }
}


