
#include "mbed.h"
#include "Hotboards_keypad.h"
#include <string>

using std::string;

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Configures the serial port
Serial pc( USBTX , USBRX );

int i;

int main()
{
    string msg;
    while(1)
    {
        // Fills kpd.key[ ] array with up-to 10 active keys.
        // Returns true if there are ANY active keys.        
        if( kpd.getKeys( ) )
        {
            // Scan the whole key list.
            for( i = 0 ; i <= LIST_MAX ; i++ )
            {
                // Only find keys that have changed state.
                if( kpd.key[ i ].stateChanged )
                {
                    // Report active key state : IDLE, PRESSED, HOLD, or RELEASED
                    switch( kpd.key[ i ].kstate )
                    {
                        case PRESSED:
                            msg = " PRESSED. ";
                            break;
                        case HOLD:
                            msg = " HOLD. ";
                            break;
                        case RELEASED:
                            msg = " RELEASED. ";
                            break;
                        case IDLE:
                            msg = " IDLE. ";
                            break;
                        default:
                            break;
                    }
                    // Print the current state of the key pressed
                    pc.printf( "Key " );
                    pc.printf( "%c" , kpd.key[ i ].kchar );
                    pc.printf( "%s" , msg.c_str() );
                    pc.printf( "\n\r" );
                }
            }
        }
    }
}
