
#include "mbed.h"
#include "Hotboards_keypad.h"

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Configures the serial port
Serial pc( USBTX , USBRX );

//
int loopCount = 0;
int timer_t = 0;

// Configures a timer
Timer t;

int main()
{
    // Starts the timer
    t.start( );
    pc.printf( "Press any key: ");
    

    // Try playing with different debounceTime settings to see how it affects
    // the number of times per second your loop will run. The library prevents
    // setting it to anything below 1 millisecond.
    kpd.setDebounceTime ( 100 ); // setDebouncetime( ms );
    while(1)
    {
        // Poll the keypad to look for any activation
        char key = kpd.getKey( );
        
        // Reports the number of times through the loop in 1 second. This will give
        // you a relative idea of just how much the debounceTime has changed the
        // speed of your code. If you set a high debounceTime your loopCount will
        // look good but your keypresses will start to feel sluggish.        
        if(( t.read_ms( ) - timer_t ) > 1000 )
        {
            pc.printf( "Your loop code ran " );
            pc.printf( "%d" , loopCount );
            pc.printf( " times over the last second" );
            loopCount = 0;
            pc.printf( "\n\r" );
            timer_t = t.read_ms( );
        }
        loopCount ++;
        
        // If any key was pressed
        if( key )
        {
            // Display the key pressed on serial port
            pc.printf( "%c" , key );
        }
    }
}
