#include "mbed.h"
#include "HPM.h"

#define TESTER_VERSION 1.0

Serial pc(USBTX, USBRX, 115200);

#if MODE == 4
RawSerial link(D0, D1);
#endif

main()
{
    pc.printf("Starting HPM library Tester Version %s\n", TESTER_VERSION);
#if MODE == 4
    HPM pm(&link);
#else
    HPM pm(D1, D0);  //Create an instance of a HPM class object
#endif
    pm.setLog(&pc);  //Attach a log output stream
    pm.startAutoRead(); //Start the sensor in continous read mode
    for(int index = 0; index < 5; index++) { //Display 5 readings
        pm.getPMReadings(); 
        }
    pm.stopAutoRead(); //Shut the sensor down
    
    }

