// Project
#include "mbed.h"
#include "Motor.h"
#include "ultrasonic.h"

Serial pc (USBTX, USBRX);
BusOut myled(LED1,LED2,LED3,LED4);
Serial blue(p28,p27);
Motor motorA(p23, p6, p5); // pwm, fwd, rev
Motor motorB(p24, p11, p12); // pwm, fwd, rev

int dist;

void dist_func(int distance)
{
    //put code here to execute when the distance has changed
    pc.printf("Distance %d mm\r\n", distance);
    dist = distance;
}
ultrasonic mu(p6, p7, .1, 1, &dist_func);

int main()
{
    float motorSpeed_A = 0.0;
    float motorSpeed_B = 0.0;
    char bnum = 0;
    char bhit = 0;
    mu.startUpdates();//start measuring the distance
    while(1)
    {   
        motorA.speed(motorSpeed_A);
        motorB.speed(motorSpeed_B);
        if (blue.getc() == '!') {
            if (blue.getc() == 'B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc() == char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '1'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1' : // number button 1
                        if (bhit == '1'){
                            }
                        else {
                            mu.checkDistance();
                            if (dist <= 50){
                                motorSpeed_A = 0.0; // Stop
                                motorSpeed_B = 0.0; // Stop
                                }
                            }
                        break;
                        case '2' : // number button 2
                        if (bhit == '1'){
                            }
                        else {
                            motorSpeed_A -= 0.2; // decreasing speed
                            motorSpeed_B -= 0.2; // decreasing speed
                            }
                        break;
                        case '3' : // number button 3
                        if(bhit == '1'){
                        }
                        else {
                            motorSpeed_A = 0.0; // Stop
                            motorSpeed_B = 0.0; // Stop
                            }
                        break;
                        case '4' : // Reverse Rotation
                            // Hitting 4 on the numpad activates reverse mode and turns 
                            if (bhit == '1'){
                                }
                            else {
                                if (blue.getc() == '!') {
                                if (blue.getc() == 'B') { //button data packet
                                bnum = blue.getc(); //button number
                                bhit = blue.getc(); //1=hit, 0=release
                                if (blue.getc() == char(~('!' + 'B' + bnum + bhit))) {
                                    // For reverse turn
                                    myled = bnum - '1';
                                    switch (bnum) {
                                        case '7' : // arrow left
                                            if (bhit == '1'){
                                                            }
                                            else {
                                                motorSpeed_A = -0.5;
                                                motorSpeed_B = -0.1;
                                                    }
                                            break;
                                        case '8' : // arrow right
                                            if (bhit == '1'){
                                                            }
                                            else {
                                                motorSpeed_A = -0.1;
                                                motorSpeed_B = -0.5;
                                                }
                                        default:
                                    break;                                     
                                        }
                                    }
                                }
                            }
                        break;                                        
                        case '5' : // arrow up button
                            if (bhit == '1') {
                                //add hit code here
                                motorSpeed_A += 0.2; // increasing speed
                                motorSpeed_B += 0.2; // increasing speed
                                }
                        break;
                        case '6' : // arrow down
                            if (bhit == '1') {
                                }
                            else {
                                motorSpeed_A -= 0.2; // decreasing speed
                                motorSpeed_B -= 0.2; // decreasing speed
                                }
                        break;
                        case '7' : // arrow left
                            if (bhit == '1'){
                                }
                            else {
                                motorSpeed_A = 0.5;
                                motorSpeed_B = 0.1;
                                }
                        break;
                        case '8' : // arrow right
                            if (bhit == '1'){
                                }
                            else {
                                motorSpeed_A = 0.1;
                                motorSpeed_B = 0.5;
                                }
                        //break;                             
                        default :
                        break;
                                }
                            }
                        }
                    }
                }
            }
        }