#include "Game.h"

void Game::initTable()
{
    if( oldLevel == L_INTRO ) {
        if( level == L_INTRO ) return;

        disp.clear();
        disp.drawString(133, TITY, "NOKO", MAGENT, BLACK);
        disp.drawString(134, TITY+10, "BAM!", RED, BLACK);
        disp.drawString(130, LEVY, "LEVEL", YELLOW, BLACK);
        disp.drawString(133, BESY, "BEST",  YELLOW, BLACK);
        disp.drawString(136, YOUY, "YOU",  YELLOW, BLACK);
        disp.drawString(130, MOVY, "MOVES", YELLOW, BLACK);
    }
    oldLevel = level;
    
    levelCompleted = false;
    moves = 0;

    disp.fillRect( 0, 112, 160, 16, 0 );
    fillTable( 0, 0, TABH, TABW, WALL );

    switch( level ) {
        case L_INTRO:
            disp.clear();
            
            disp.drawString( 28,  9, "NOKO", MAGENT, BLACK, 2 );
            disp.drawString( 88,  9, "BAM!", RED, BLACK, 2 );
            
            disp.drawString( 24, 32, "MOVE  THE BALLS >", YELLOW, BLACK );
            disp.drawString( 24, 42, "TO THEIR PLACES >", YELLOW, BLACK );
            
            disp.drawString( 36, 58, "TRY LESS MOVES", GREEN, BLACK );
            
            //disp.drawString( 30, 61, "ARROWS = MOVE", YELLOW, BLACK );
            disp.drawString( 30, 74, "SQUARE = LEVEL ++", YELLOW, BLACK );
            disp.drawString( 30, 84, "CIRCLE = LEVEL --", YELLOW, BLACK );
            disp.drawString( 30, 94, "LEFT + UP = CLEAR", YELLOW, BLACK );
            
            disp.drawString( 30, 111, "HAVE A GOOD TIME!", RED, BLACK );

            showImage( 132, 32, BLACK, BLUE, 0x1051,0x0175, 0x1651, 0 );
            showImage( 132, 42, GRAY, WHITE, 0x3311, 0 );
            break;
            
        case L_START: // 1 (1.0)
            fillTableV( FREE, 0x4566, 0 );
            fillTableV( MARK, 0x4912, 0 );
            fillTableV( BALL, 0x9511, 0x9811, 0 );
            best = 9;
            break;

        case L_FIRSTBAM:    // 2 (1.0)
            fillTableV( BONG, 0x4468, 0 );
            fillTableV( FREE, 0x4566, 0 );
            fillTableV( WALL, 0x6411, 0 );
            fillTableV( MARK, 0x9512, 0 );
            fillTableV( BALL, 0x4811, 0x4A11,0 );
            best = 9;
            break;
            
        case L_ZIGZAG:      // 3 (1.0)
            fillTableV( FREE, 0x4631, 0x4741, 0x5841, 0x6941, 0x7A41, 0x8B41, 0x9C31, 0 );
            fillTableV( MARK, 0x9C11, 0xBC11, 0 );
            fillTableV( BALL, 0x4611, 0x6611,0 );
            best = 11;
            break;
            
        case L_FIRSTPOS:    // 4 (1.0)
            fillTableV( FREE, 0x4566, 0 );
            fillTableV( WALL, 0x9711, 0 );
            fillTableV( MAR1, 0x5A11, 0x4A11, 0 );
            fillTableV( BAL1, 0x9911, 0x9A11, 0 );
            best = 13;
            break;
            
        case L_MANYBOX:     // 41 (1.0)
            fillTableV( FREE, 0x1133, 0x1513, 0x1931, 0x1B31, 0x2611, 0x2913, 0x3513, 0 );
            fillTableV( FREE, 0x5232, 0x5532, 0x6923, 0 );
            fillTableV( FREE, 0x9133, 0x9533, 0x9933, 0 );
            fillTableV( WALL, 0x9711, 0xA211, 0xA611, 0xAA11, 0xB911, 0 );
            fillTableV( MARK, 0x3311, 0x3711, 0x3B11, 0x7311, 0x7711, 0x7B11, 0xB311, 0xB711, 0xBB11, 0 );
            fillTableV( BALL, 0x1111, 0x1511, 0x1911, 0x5211, 0x5511, 0x6911, 0x9111, 0x9511, 0x9911, 0 );
            best = 9;
            break;
            
        /*
        case L_NOBACK:      // 470 (1.8)
            fillTableV( FREE, 0x03DD, 0 );
            fillTableV( WALL, 0x0321, 0xA411, 0xAE11, 0xB511, 0xCD11, 0 );
            fillTableV( BONG, 0x0111, 0x041C, 0x152B, 0x3011, 0x366A, 0xB617, 0 );
            fillTableV( MARK, 0x1111, 0x3111, 0 );
            fillTableV( BALL, 0x1111, 0x3111, 0 );
            fillTableV( MAR1, 0xCF11, 0xBF11, 0xCC11, 0 );
            fillTableV( BAL1, 0x1411, 0x3511, 0x2311, 0 );
            best = 26;
            break;
        */
            
        case L_FEWMOVES:    //  44 2.1
            fillTableV( FREE, 0x23AA, 0 );
            fillTableV( WALL, 0x3712, 0x6518, 0x8831, 0 );
            fillTableV( MARK, 0x9611, 0x9A11, 0 );
            fillTableV( BALL, 0x5611, 0x5A11, 0 );
            best = 18;
            break;
            
        case L_LABYRINTH:   // 59 2.5
            fillTableV( FREE, 0x0511, 0x1016, 0x1A16, 0x2311, 0x2F11, 0x3014, 0x3917, 0x4011, 0x4614, 0 );
            fillTableV( FREE, 0x5012, 0x5611, 0x5B15, 0x6111, 0x6612, 0x6913, 0x6F41, 0x7012, 0x7313, 0 );
            fillTableV( FREE, 0x7731, 0x7931, 0x7D13, 0x8011, 0x8311, 0x8541, 0x8B41, 0x8D11, 0x9014, 0 );
            fillTableV( FREE, 0x9713, 0x9B13, 0xB016, 0xB723, 0xBB15, 0xC011, 0xCF11, 0xD010, 0 );
            fillTableV( MAR1, 0x0011, 0x0B11, 0x0F11, 0x411, 0 );
            fillTableV( BAL1, 0xD614, 0 );
            best = 98;
            break;
            
        case L_FACEFOUR:    //  69 3.1
            fillTableV( FREE, 0x23AA, 0 );
            fillTableV( WALL, 0x4511, 0x4A11, 0x9712, 0 );
            fillTableV( MAR1, 0x5611, 0x5911, 0x8712, 0 );
            fillTableV( BAL1, 0x9A11, 0x9511, 0x5811, 0x5711, 0 );
            best = 50;
            break;
            
        case L_MANYBAM:     // 101 (3.2)
            fillTableV( FREE, 0x23AA, 0 );
            fillTableV( WALL, 0x6611, 0x6911, 0xB411, 0 );
            fillTableV( BONG, 0x2516, 0x2CA1, 0x3391, 0x4611, 0x4813, 0x6511, 0x7641, 0x7941, 0 );
            fillTableV( BONG, 0x8431, 0x8B41, 0 );
            fillTableV( MAR1, 0x6712, 0 );
            fillTableV( BAL1, 0x5911, 0x5511, 0 );
            best = 28;
            break;
            
        case L_CHANGEPOS:   // 8 (3.7)
            fillTableV( FREE, 0x2691, 0x2891, 0 );
            fillTableV( MAR1, 0x3711, 0x5711, 0x7711, 0x9711, 0 );
            fillTableV( BAL1, 0x9711, 0x7711, 0x5711, 0x3711, 0 );
            best = 22;
            break;
            
        case L_ONLYTWO:     // 73 (3.9)
            fillTableV( FREE, 0x117E, 0x831B, 0x913F, 0xC11C, 0xCE12, 0 );
            fillTableV( BONG, 0x9F11, 0xA111, 0 );
            fillTableV( MARK, 0x8011, 0 );
            fillTableV( BALL, 0x8F11, 0 );
            fillTableV( MAR1, 0x1111, 0x8E11, 0 );
            fillTableV( BAL1, 0x9011, 0x8011, 0 );
            best = 50;
            break;
            
        case L_NUMBLOCKS:   // 94 (4.0)
            fillTableV( FREE, 0x0211, 0x03E4, 0x09E4, 0x2F11, 0x3083, 0x3D83, 0xB011, 0xDD11, 0 );
            fillTableV( MAR1, 0x1E11, 0xCE11, 0x1F11, 0xDE11, 0x2522, 0 );
            fillTableV( BAL1, 0xA922, 0x1111, 0x0111, 0xC012, 0 );
            best = 54;
            break;
            
        case L_SEPARATED:   // 14 10 (4.6)
            fillTableV( FREE, 0x4166, 0x4966, 0 );
            fillTableV( WALL, 0x5311, 0 );
            fillTableV( BONG, 0x4211, 0x4A11, 0x5611, 0x5E11, 0x6411, 0x7911, 0x7B11, 0x8111, 0x8E11, 0x9611, 0 );
            fillTableV( MARK, 0x7511, 0x8A11, 0 );
            fillTableV( BALL, 0x8311, 0x8B11, 0 );
            best = 17;
            break;
            
        case L_NUMBERMIX:   // 15 79 (4.7)
            fillTableV( FREE, 0x11CE, 0 );
            fillTableV( WALL, 0x5321, 0x5C21, 0 );
            fillTableV( MAR1, 0x8D11, 0x7D11, 0x2D11, 0x5D11, 0x4D11, 0x1D11, 0x6D11, 0x3D11, 0 );
            fillTableV( BAL1, 0xCE11, 0xCD11, 0xCC11, 0xCB11, 0xCA11, 0xC911, 0xC811, 0xC711, 0 );
            best = 47;
            break;
            
        case L_STEPS:       // 16 381 (5.0)
            fillTableV( FREE, 0x2361, 0x2561, 0x2761, 0x2961, 0x2B61, 0x834A, 0 );
            fillTableV( WALL, 0x541C, 0 );
            fillTableV( MAR1, 0x2411, 0x2611, 0x2811, 0x2A11, 0x2C11, 0 );
            fillTableV( BAL1, 0x6311, 0x6511, 0x6711, 0x6911, 0x6B11, 0 );
            best = 48;
            break;

        case L_BAMPOS:      // 17 6 (5.7)
            fillTableV( BONG, 0x3488, 0 );
            fillTableV( FREE, 0x4566, 0 );
            fillTableV( WALL, 0x5911, 0 );
            fillTableV( MAR1, 0x6811, 0x4A11, 0 );
            fillTableV( BAL1, 0x4A11, 0x6811, 0 );
            best = 15;
            break;
            
        case L_CHESS:       // 18 25 (5.7)
            fillTableV( FREE, 0x24A1, 0x26A1, 0x28A1, 0x2AA1, 0x2CA1, 0 );
            fillTableV( FREE, 0x3711, 0x3B11, 0x4511, 0x4911, 0x5711, 0x5B11, 0 );
            fillTableV( FREE, 0x8511, 0x8911, 0x9711, 0x9B11, 0xA511, 0xA911, 0 );
            fillTableV( BONG, 0x2511, 0x2911, 0x6511, 0x6911, 0x7711, 0x7B11, 0xB711, 0xBB11, 0 );
            fillTableV( MAR1, 0x2D11, 0x4D11, 0x6D11, 0x8D11, 0xAD11, 0 );
            fillTableV( BAL1, 0xB311, 0x9311, 0x7311, 0x5311, 0x3311, 0 );
            best = 46;
            break;
            
        case L_HAMMER:      // 19 464 (6.3)
            fillTableV( FREE, 0x0015, 0x0913, 0x0D13, 0x1041, 0x1616, 0x1F31, 0x222C, 0x422B, 0 );
            fillTableV( FREE, 0x612E, 0x824C, 0x9051, 0x9F51, 0xC612, 0xD015, 0xD917, 0 );
            fillTableV( MARK, 0x4F11, 0x5623, 0x7721, 0 );
            fillTableV( BALL, 0x0612, 0x4F11, 0x6021, 0x6F21, 0xD612, 0 );
            best = 50; // (Possible 37)
            break;
            
        case L_CAREMOVES:   // 20 128 (6.5)
            fillTableV( FREE, 0x11CE, 0xB031, 0 );
            fillTableV( WALL, 0x1A51, 0x3521, 0x3B12, 0x711A, 0x8631, 0x9841, 0xA231, 0xC711, 0 );
            fillTableV( BONG, 0x1911, 0x1B24, 0x3411, 0x4611, 0x5911, 0x5B11, 0x6111, 0x7B11, 0 );
            fillTableV( BONG, 0x8441, 0x9211, 0x9B11, 0xBD22, 0xC611, 0xC911, 0 );
            fillTableV( MAR1, 0x1122, 0 );
            fillTableV( BAL1, 0xC021, 0xD111, 0xC111, 0 );
            best = 248;
            break;
            
        case L_FLUTE:       // 21 126 (6.9)
            fillTableV( FREE, 0x00E0, 0 );
            fillTableV( WALL, 0x0021, 0x0231, 0x0441, 0x0651, 0x0861, 0x0A71, 0x0C81, 0x0E91, 0xA311, 0 );
            fillTableV( BONG, 0x3111, 0x4311, 0x5511, 0x6711, 0x7911, 0x8B11, 0x9D11, 0 );
            fillTableV( MAR1, 0x0F71, 0 );
            fillTableV( BAL1, 0x0111, 0x0311, 0x0511, 0x0711, 0x0911, 0x0B11, 0x0D11, 0 );
            best = 118;
            break;

        case L_CROSS:       // 22 136 (7.0)
            fillTableV( FREE, 0x12CC, 0 );
            fillTableV( WALL, 0x1712, 0x6221, 0x6D21, 0xC712, 0 );
            fillTableV( BONG, 0x6722, 0 );
            fillTableV( MAR1, 0x5611, 0x5911, 0x8911, 0x8611, 0 );
            fillTableV( BAL1, 0x9A11, 0x9511, 0x4511, 0x4A11, 0 );
            best = 70;
            break;
            
        case L_DIAGONAL:    // 23 445 (7.1)
            fillTableV( FREE, 0x00E0, 0 );
            fillTableV( WALL, 0x0111, 0x2113, 0x4313, 0x6513, 0x8713, 0xA913, 0xCB13, 0x2A21, 0 );
            fillTableV( BONG, 0x2411, 0x5711, 0x8A11, 0xBD11, 0 );
            fillTableV( MARK, 0x0B25, 0x2E22, 0 );
            fillTableV( BALL, 0x0011, 0x1111, 0x2211, 0x3311, 0x4411, 0x5511, 0x6611, 0 );
            fillTableV( BALL, 0x7711, 0x8811, 0x9911, 0xAA11, 0xBB11, 0xCC11, 0xDD11, 0 );
            best = 78;
            break;
            
        case L_LASTSIX:     // 24 239 (7.2)
            fillTableV( FREE, 0x00E0, 0 );
            fillTableV( WALL, 0x501D, 0 );
            fillTableV( MARK, 0x0020, 0 );
            fillTableV( BALL, 0x6012, 0x6813, 0x7211, 0x7711, 0x8311, 0x8611, 0x9412, 0 );
            fillTableV( BALL, 0x8F11, 0x9E12, 0xAD13, 0xBC14, 0xCB15, 0xDA16, 0 );
            best = 119;
            break;
            
        case L_FORTYTWO:    // 24 106 (4.2)
            fillTableV( BONG, 0x00E0, 0 );
            fillTableV( FREE, 0x11CE, 0 );
            fillTableV( WALL, 0x2234, 0x5521, 0x2914, 0x3C11, 0x4914, 0x5911, 0x6914, 0 );
            fillTableV( MARK, 0xA323, 0xC312, 0 );
            fillTableV( BALL, 0x2322, 0x3A12, 0x5A12, 0 );
            best = 42;
            break;
            
        case L_ALEXAND:     // 25 7 (7.4)
            fillTableV( FREE, 0x23AA, 0 );
            fillTableV( WALL, 0x3411, 0x6611, 0xAB11, 0 );
            fillTableV( MAR1, 0x2311, 0x4511, 0x4811, 0x8611, 0 );
            fillTableV( BAL1, 0x5911, 0x8711, 0x2C11, 0x7311, 0 );
            best = 23;
            break;
            
        case L_CALCULATE:   // 26 123 (7.5)
            fillTableV( FREE, 0x3574, 0x6114, 0x7311, 0 );
            fillTableV( WALL, 0x3711, 0x9611, 0 );
            fillTableV( MAR1, 0x5633, 0 );
            fillTableV( BAL1, 0x8111, 0x4211, 0x5111, 0x9111, 0x8311, 0x9211, 0x4311, 0x9311, 0x4111, 0 );
            best = 76;
            break;
            
        case L_MANYBALLS:   // 27 9 (8.0)
            fillTable( 0, 0, TABH, TABW, FREE );
            fillTable( 0, 0, 2, TABW, MARK );
            fillTable( TABH-2, 0, 2, TABW, BALL );
            fillTable( TABH/2-1, TABW/2-1, 2, 2, WALL );
            best = 26;
            break;
            
        case L_SPIDERBAM:   // 28 110 8.1
            fillTableV( FREE, 0x00E8, 0x0841, 0x0931, 0x0A21, 0x0B11, 0x0D21, 0x1C21, 0x2B21, 0 );
            fillTableV( FREE, 0x3A21, 0x4921, 0x5841, 0x8921, 0x9A21, 0xAB21, 0xBC21, 0xCD21, 0 );
            fillTableV( FREE, 0xA841, 0xB931, 0xCA21, 0xDB11, 0 );
            fillTableV( BONG, 0x0821, 0x1511, 0x2611, 0x3122, 0x3711, 0x6111, 0x6311, 0x6511, 0x6711, 0 );
            fillTableV( BONG, 0x0821, 0x1511, 0x2611, 0x3122, 0x3711, 0x6111, 0x6311, 0x6511, 0x6711, 0 );
            fillTableV( BONG, 0x7011, 0x7211, 0x7411, 0x7611, 0x7811, 0x9122, 0xA711, 0xB611, 0xC511, 0xC821, 0 );
            fillTableV( MARK, 0x1011, 0xC011, 0 );
            fillTableV( BALL, 0x0E11, 0xDE11, 0 );
            best = 65;
            break;
            
        case L_CONFUSE:     // 29 135 (8.5)
            fillTableV( FREE, 0x11CE, 0 );
            fillTableV( WALL, 0x2212, 0x4B11, 0x5C11, 0x6D11, 0xA611, 0xCB11, 0 );
            fillTableV( BONG, 0x1511, 0x1A11, 0x3311, 0x4711, 0x5211, 0x5911, 0x7121, 0x7A21, 0 );
            fillTableV( BONG, 0x8611, 0x9C11, 0xA121, 0xC611, 0xC911, 0xCD11, 0 );
            fillTableV( MARK, 0xBE11, 0 );
            fillTableV( MAR1, 0xCE11, 0xBD11, 0xAC11, 0 );
            fillTableV( BALL, 0x1611, 0 );
            fillTableV( BAL1, 0x4411, 0x6611, 0x5511, 0 );
            best = 37;
            break;
            
        case L_PRECISE:     // 30 142 (8.8)
            fillTableV( FREE, 0x0614, 0x1631, 0x4687, 0 );
            fillTableV( WALL, 0x8842, 0 );
            fillTableV( BONG, 0x1812 ,0x4581, 0x4714, 0x5C71, 0x7811, 0x9731, 0x9A31, 0 );
            fillTableV( MAR1, 0xB611, 0xBB11, 0 );
            fillTableV( BAL1, 0x5911, 0x5811, 0 );
            best = 61;
            break;
            
        case L_ORDER:       // 31 113 (9.8)
            fillTableV( FREE, 0x4715, 0x5711, 0x5B41, 0x8A11, 0 );
            fillTableV( BONG, 0x5A11, 0 );
            fillTableV( MAR1, 0x6713, 0x7713, 0x8713, 0 );
            fillTableV( BAL1, 0x8911, 0x8711, 0x7711, 0x6711, 0x6911, 0x7811, 0x7911, 0x6811, 0x8811, 0 );
            best = 50;
            break;
            
        case L_GRANDMAST:   // 32 143 (10.0)
            fillTableV( FREE, 0x00E0, 0 );
            fillTableV( WALL, 0x0541, 0x1742, 0x2043, 0x3D33, 0x5314, 0x5814, 0x6911, 0x6C11, 0 );
            fillTableV( WALL, 0x7211, 0x7611, 0x7A11, 0x8411, 0x8811, 0x8E11, 0x9713, 0 );
            fillTableV( WALL, 0xA013, 0xA41C, 0xB313, 0xC611, 0xC814, 0xD014, 0xD914, 0 );
            fillTableV( BONG, 0x1911, 0x1B11, 0x1D11, 0x1F11, 0x2831, 0x3231, 0x3B21, 0 );
            fillTableV( BONG, 0x4111, 0x5C11, 0x6611, 0x9A11, 0xA714, 0xB411, 0xB611, 0 );
            fillTableV( BONG, 0xC511, 0xCC11, 0 );
            fillTableV( MARK, 0xDB11, 0 );
            fillTableV( MAR1, 0xDD11, 0xDF11, 0xDE11, 0x2021, 0x2111, 0x8C11, 0x9611, 0x9E11, 0 );
            fillTableV( BALL, 0xDA11, 0 );
            fillTableV( BAL1, 0xC211, 0xC012, 0x4E12, 0x3F11, 0x5011, 0x8311, 0x6B11, 0 );
            best = 299;
            break;
    }
    
    if( level != L_INTRO ) {
        showNumber( LEVY, level );
        showNumber( BESY, best );
        showNumber( YOUY, your[level] );
        showNumber( MOVY, moves );
    }
    
    led1 = 0; led2 = 0;
    pwm = 0; pwm.period_ms(1);
}