#include "mbed.h"

#include "DisplayN18.h"

#pragma once

#define RED     0x1F00
#define GREEN   0xE007
#define BLUE    0x00F8

#define YELLOW  0xFF07
#define CYAN    0xE0FF
#define MAGENT  0x1FF8

#define WHITE   0xFFFF
#define LGRAY   0x18C6
#define GRAY    0x1084
#define DGRAY   0x0842
#define BLACK   0x0000

#define TABW 16
#define TABH 14

#define WALL 0x01
#define BONG 0x02
#define FREE 0x03
#define MARK 0x04
#define MAR1 0x05
#define BALL 0x10
#define BAL1 0x20

#define TITY 0
#define LEVY 24
#define BESY 48
#define YOUY 72
#define MOVY 96

#define L_INTRO     0
#define L_START     (L_INTRO     + 1)   //   1 1.0   9
#define L_FIRSTBAM  (L_START     + 1)   //   2 1.0   9
#define L_ZIGZAG    (L_FIRSTBAM  + 1)   //   3 1.0  11
#define L_FIRSTPOS  (L_ZIGZAG    + 1)   //   4 1.0  13
#define L_MANYBOX   (L_FIRSTPOS  + 1)   //  41 1.0   9
//#define L_NOBACK    (L_MANYBOX   + 1)   // 470 1.8  26
#define L_FEWMOVES  (L_MANYBOX   + 1)   //  44 2.1  18
#define L_BAMPOS    (L_FEWMOVES  + 1)   //   6 5.7  15
#define L_LABYRINTH (L_BAMPOS    + 1)   //  59 2.5  98
#define L_FACEFOUR  (L_LABYRINTH + 1)   //  69 3.1  50
#define L_MANYBAM   (L_FACEFOUR  + 1)   // 101 3.2  28
#define L_CHANGEPOS (L_MANYBAM   + 1)   //   8 3.7  22
#define L_ONLYTWO   (L_CHANGEPOS + 1)   //  73 3.9  50
#define L_NUMBLOCKS (L_ONLYTWO   + 1)   //  94 4.0  54
#define L_SEPARATED (L_NUMBLOCKS + 1)   //  10 4.6  17
#define L_NUMBERMIX (L_SEPARATED + 1)   //  79 4.7  47
#define L_STEPS     (L_NUMBERMIX + 1)   // 381 5.0  48
#define L_CHESS     (L_STEPS     + 1)   //  25 5.7  46
#define L_HAMMER    (L_CHESS     + 1)   // 464 6.3  50
#define L_CAREMOVES (L_HAMMER    + 1)   // 128 6.5 248
#define L_FLUTE     (L_CAREMOVES + 1)   // 126 6.9 118
#define L_CROSS     (L_FLUTE     + 1)   // 136 7.0  70
#define L_DIAGONAL  (L_CROSS     + 1)   // 445 7.1  78
#define L_LASTSIX   (L_DIAGONAL  + 1)   // 239 7.2 119
#define L_FORTYTWO  (L_LASTSIX   + 1)   // 106 4.9  42
#define L_ALEXAND   (L_FORTYTWO  + 1)   //   7 7.4  23
#define L_CALCULATE (L_ALEXAND   + 1)   // 123 7.5  76
#define L_MANYBALLS (L_CALCULATE + 1)   //   9 8.0  26
#define L_SPIDERBAM (L_MANYBALLS + 1)   // 110 8.1  65
#define L_CONFUSE   (L_SPIDERBAM + 1)   // 135 8.5  37
#define L_PRECISE   (L_CONFUSE   + 1)   // 142 8.8  61 (nao verificado)
#define L_ORDER     (L_PRECISE   + 1)   // 113 9.8  50
#define L_GRANDMAST (L_ORDER     + 1)   // 143  10 299
#define L_LAST      (L_GRANDMAST + 0)   // LAST LEVEL

class Game
{    
    static const char I2C_ADDR = 0x1C << 1;

    int tickCounter, tickWin, bamTicksLeft;
    char lastKey;
    
    unsigned char table[14][16];
    unsigned short change[14];
    unsigned short piece[7][7];
    int best, moves;
    short your[32];
    int level, oldLevel;
    bool levelCompleted;
    unsigned char bamX, bamY;

    DigitalIn left, right, down, up, square, circle; 
    DigitalOut led1, led2;
    PwmOut pwm;
    AnalogIn ain;
    I2C i2c;
    DisplayN18 disp;
    
    void showNumber(int y, int val);
    
    void initialize();

    void checkButtons();

    void playBam();
    void playSound();
   
    void initTable();
    void fillTable(char i0, char j0, char h, char w, unsigned char v);
    void fillTableV(unsigned char v, ...);
    void showTable();
    void moveTable(int di, int dj, int i0, int i2, int j0, int j2); 
    void showPiece(int i, int j);
    void fillPiece(int x0, int y0, int w, int h, unsigned short v);
    void fillPieceV(unsigned short color, ...);
    void showImage( unsigned char x, unsigned char y, unsigned short back, unsigned short front, ... );
    
    public:
        Game();
        void tick();
};