#include "mbed.h"

#pragma once

class DisplayN18 {
    static const unsigned char STEP = 4;
    
    DigitalOut resetPin;
    DigitalOut backlightPin;
    DigitalOut rsPin;
    DigitalOut csPin;
    SPI spi;

    void writeCommand(unsigned char command);
    void writeData(unsigned char data);
    void writeData(const unsigned char* data, unsigned int length);

    void reset();
    void initialize();
    void setClippingArea(unsigned char x, unsigned char y, unsigned char width, unsigned char height);

    public:
        DisplayN18();
        /*
        static const unsigned short BLUE = 0x00F8;
        static const unsigned short GREEN = 0xE007;
        static const unsigned short RED = 0x1F00;
        static const unsigned short CYAN = 0xE0FF;
        static const unsigned short MAGENT = 0x1FF8;
        static const unsigned short YELLOW = 0xFF07;
        static const unsigned short WHITE = 0xFFFF;
        static const unsigned short LGRAY = 0x18C6;
        static const unsigned short GRAY = 0x1084;
        static const unsigned short DGRAY = 0x0842;
        static const unsigned short BLACK = 0x0000;
        */
        static const unsigned int WIDTH = 160;
        static const unsigned int HEIGHT = 128;
        static const unsigned char CHAR_WIDTH = 5;
        static const unsigned char CHAR_HEIGHT = 8;
        static const unsigned char CHAR_SPACING = 1;

        static unsigned short rgbToShort(unsigned char r, unsigned char g, unsigned char b);

        void clear(unsigned short backColor = 0x0000);
        void draw(const unsigned short* data, int x, int y, int width, int height);
        void setPixel(int x, int y, unsigned short foreColor);

        void fillRect(int x, int y, int width, int height, unsigned short foreColor);
        void drawRect(int x, int y, int width, int height, unsigned short foreColor);

        void fillCircle(int x, int y, int radius, unsigned short foreColor);
        void drawCircle(int x, int y, int radius, unsigned short foreColor);

        //void drawLine(int x0, int y0, int x1, int y1, unsigned short foreColor);

        void drawNumber(int x, int y, const char character, unsigned short foreColor, unsigned short backColor);
        void drawCharacter(int x, int y, const char character, unsigned short foreColor, unsigned short backColor, unsigned char fontSize = 1);
        void drawString(int x, int y, const char* str, unsigned short foreColor, unsigned short backColor, unsigned char fontSize = 1);
};