#ifndef TIME_CONFIG_H
#define TIME_CONFIG_H
 
#include "mbed.h"

time_t example_time() 
{
    // set an intial time
    //  ...not really necessary for this example, but it beats setting it to 0 or some non-obvious large integer (# of seconds since 1/1/1970)
    time_t rawtime=0;

    struct tm * init_timeinfo;

    // initialize time
    init_timeinfo = localtime(&rawtime); // note:  must initialize the struct with this before trying to set components
                                 // ...else code goes into the weeds!!
    /*
    init_timeinfo->tm_sec =     atoi(ss);
    init_timeinfo->tm_min =     atoi(mm);
    init_timeinfo->tm_hour =    atoi(hh);
    init_timeinfo->tm_mday =    atoi(DD);
    init_timeinfo->tm_mon =     atoi(MM) - 1;
    init_timeinfo->tm_year =    (2000+atoi(AA)) - 1900;       
    */
    int Day=01;
    int Month=01;
    int Year=2019;
    int Hour=0;
    int Minutes=0;
    int Seconds=00;
    
    init_timeinfo->tm_sec =     Seconds;
    init_timeinfo->tm_min =     Minutes;
    init_timeinfo->tm_hour =    Hour;
    init_timeinfo->tm_mday =    Day;
    init_timeinfo->tm_mon =     Month - 1;
    init_timeinfo->tm_year =    Year - 1900;    

    // compute the proper value for time in time_t type
    rawtime = mktime(init_timeinfo);
    return rawtime;
    
} //end time_t example_time() 

void update_rtc() 
{
    // for use as interrupt routine, to insure that RTC is updated periodically
    //  ...if rtc is not read before the underlying counter rolls over (typically 512 seconds), the RTC value will be wrong
    //  ...ideally this would be done as part of the nrf51_rtc method, but I couldn't get it to behave (see nrf51_rtc.cpp for details)
    rtc.time();
    
} //end update_rtc() 

void time_init()
{
    // user selectable, any time < 512 seconds is OK
    #define PERIODIC_UPDATE 1
    Ticker rtc_ticker;
    rtc_ticker.attach(&update_rtc, PERIODIC_UPDATE); // update the time regularly

    time_t initial_time = example_time();
    rtc.set_time(initial_time);
    
} //end time_init()

void print_time() 
{
    // called when a button is pushed, this prints the current time to the USB-connected console

    time_t rawtime=rtc.time();

    // massage the time into a human-friendly format for printing
    struct tm * timeinfo;
    timeinfo = localtime(&rawtime);
    char date[24];
    strftime(date,sizeof(date),"%H:%M:%S em %d/%m/%G",timeinfo);
    Open.printf("Horario e data atual: %s.\r\n",date);
    
}// end print_time() 

void ask_time(char date[100]) 
{  
    time_t rawtime=rtc.time();

    // massage the time into a human-friendly format for printing
    struct tm * timeinfo;
    timeinfo = localtime(&rawtime);
    char buff1[100];
    strftime(buff1,sizeof(buff1),"%H-%M-%S",timeinfo);
    sprintf(date,"%s,",buff1);
    
} //end ask_time() 

void ask_day(char daya[2]) 
{
    time_t rawtime=rtc.time();

    // maessage the time into a human-friendly format for printing
    struct tm * timeinfo;
    timeinfo = localtime(&rawtime);
    strftime(daya,sizeof(daya),"%d",timeinfo);
    
} //end ask_day()


#endif
