#include "mbed.h"
#include "BluetoothSerial.h"

#define TEMPS_L 0.25
#define TEMPS_M 0.2
#define TEMPS_S 0.1
#define LOOP_L 40
#define LOOP_M 50
#define LOOP_S 100

const int Vmax = 3.3;   //3.3V que pot suportar el pin ADC

BluetoothSerial bt(D5, D4);     // TX, RX

AnalogIn sensor0(A0);   //dit petit
AnalogIn sensor1(A1);   //dit anular
AnalogIn sensor2(A2);   //dit mig
AnalogIn sensor3(A3);   //dit index
AnalogIn sensor4(A4);   //dit gros

DigitalOut rLed(LED1, 1);   //Vermell
DigitalOut gLed(LED2, 1);   //Verd
DigitalOut bLed(LED3, 1);   //Blau           R+G+B = White

float force0[LOOP_M], force1[LOOP_M], force2[LOOP_M], force3[LOOP_M], force4[LOOP_M];

/*
*   LEDS
*/
void Apagat() {
    rLed = 1;   
    gLed = 1;
    bLed = 1;   
}

void Blanc() {
    rLed = 0;   
    gLed = 0;
    bLed = 0;   
}

void Taronja() {
    rLed = 0;   
    gLed = 0;
    bLed = 1;   
}

void Vermell() {
    rLed = 0;   
    gLed = 1;
    bLed = 1;   
}

void Verd() {
    rLed = 1;   
    gLed = 0;
    bLed = 1;   
}

/*
*   Funcions que recopila la força de cada dit 
*/
float dit_gros() 
{
    float f;
    float Vfsr0 = Vmax * sensor4.read();
    
    if (Vfsr0 < 0.01) 
        f = 0;
    else if (Vfsr0 <= 1) {
        f = 101.01 * Vfsr0;
    } else {
        f = 36.508 * Vfsr0;
        f += 56.473 * Vfsr0 * Vfsr0; 
    }
    
    return f;
}

float dit_index()
{
    float Vfsr1 = Vmax * sensor3.read();
    float f;
    
    if (Vfsr1 < 0.01) 
        f = 0;
    else if (Vfsr1 <= 1) {
        f = 101.01 * Vfsr1;
    } else {
        f = 36.508 * Vfsr1;
        f += 56.473 * Vfsr1 * Vfsr1; 
    }
    
    return f;
}

float dit_mig() 
{
    float Vfsr2 = Vmax * sensor2.read();
    float f;
    
    if (Vfsr2 < 0.01) 
        f = 0;
    else if (Vfsr2 <= 1) {
        f = 101.01 * Vfsr2;
    }else {
        f = 36.508 * Vfsr2;
        f += 56.473 * Vfsr2 * Vfsr2; 
    }
    
    return f;
}

float dit_anular() 
{
    float Vfsr3 = Vmax * sensor1.read();
    float f;
    
    if (Vfsr3 < 0.01) 
        f = 0;
    else if (Vfsr3 <= 1) {
        f = 101.01 * Vfsr3;
    } else {
        f = 36.508 * Vfsr3;
        f += 56.473 * Vfsr3 * Vfsr3; 
    }
    
    return f;
}

float dit_petit()
{
    float Vfsr4 = Vmax * sensor0.read();
    float f;
    
    if (Vfsr4 < 0.01) 
        f = 0;
    else if (Vfsr4 <= 1) {
        f = 101.01 * Vfsr4;
    } else {
        f = 36.508 * Vfsr4;
        f += 56.473 * Vfsr4 * Vfsr4; 
    }
    
    return f;
}

/*
*   Llegir anterior: Llegeix i envia els resultats de l'exercici anterior al mobil
*       - Color Blanc
*/
void llegir_anterior() {
    int i;
    
    Blanc();
    
    bt.puts("\n-------------------------");
    bt.puts("EXERCICI ANTERIOR: \n");
    
    for(i=0; i<LOOP_M; i++) {
        bt.printf("\r\n   Dit gros: %.2f g", force4[i]);
        bt.printf("\r\n  Dit index: %.2f g", force3[i]);
        bt.printf("\r\n    Dit mig: %.2f g", force2[i]);
        bt.printf("\r\n Dit anular: %.2f g", force1[i]);
        bt.printf("\r\n  Dit petit: %.2f g", force0[i]);
        bt.puts("\n");       
    }
    
}

/*
*   Actiu: Sistema actiu, llegeix i envia les dades del sensor al mobil
*       - Led Verd
*   L: wait(0.25) x 40 = 10 segons       --> TEMPS_L i LOOP_L
*   M: wait(0.2) x 40 = 10 segons      --> TEMPS_M i LOOP_M
*   S: wait(0.1) x 100 = 10 segons      --> TEMPS_S i LOOP_S
*
*/
void actiu() {
    int i;   
    
    Verd();
    bt.puts("\n\n---------------------");
    
    for(i=0; i<LOOP_M; i++) 
    {        
        force4[i] = dit_gros();
        force3[i] = dit_index();
        force2[i] = dit_mig();
        force1[i] = dit_anular();
        force0[i] = dit_petit();
        
        bt.puts("\n");
        bt.printf("\r\n   Dit gros: %.2f g", force4[i]);
        bt.printf("\r\n  Dit index: %.2f g", force3[i]);
        bt.printf("\r\n    Dit mig: %.2f g", force2[i]);
        bt.printf("\r\n Dit anular: %.2f g", force1[i]);
        bt.printf("\r\n  Dit petit: %.2f g", force0[i]);
        bt.puts("\n");
        
        wait(TEMPS_M); 
    }
    bt.puts("\n\n---------------------");
}

/*
*   Preparat: Sistema preparat per passar actiu. El sistema ja esta connectat via Bluetooth. 
*           - Led Taronja
*/
void preparat() {
    for(int i=0; i<3; i++) {
        Taronja();
        wait(1);
        Apagat();
        wait(1);
    }
}


int main() {
    // Inicialitzacio variables
    int estat = 0;
    
    bt.puts("\r\n________________________________________________________");
    bt.puts("\r\nSignificat dels colors dels leds de la placa FRDM KL25Z:");
    bt.puts("\r\n- Color Vermell: Sistema inactiu");
    bt.puts("\r\n- Color Taronja: Sistema preparat i en espera");
    bt.puts("\r\n- Color Verd: Sistema actiu, es recopila les dades durant 10 segons");
    bt.puts("\r\n- Color Blanc: Forces de l'exercici anterior");
    bt.puts("\r\nEls exercicis s'han de realitzar en color verd.");
    bt.puts("\r\nSi es desconnecta el Bluetooth, apreta el reset de la placa.");
    
    while(1) { 
        //Sistema inactiu
        Vermell();
        wait(2);
        
        bt.puts("\n\r\n\r");
        bt.puts("- Prem '1' per activar el sistema: ");
        bt.puts("- Prem '2' per veure els resultats de l'exercici anterior: ");   
        bt.scanf("%d", &estat);
        wait(0.5);
        
        //Estat del sistema
        if(estat == 1)  {  
            preparat(); 
            
            actiu();
        }
        else if(estat == 2) {
            llegir_anterior();
        }
        
        estat = 0;
        
    }//end while(1)
    
} //end    