#ifndef __SENSORS_H__
#define __SENSORS_H__

#include "mbed.h"
#include "LSM9DS1.h"
#include "GPS_I2C.h"

#include <iostream>
#include <string>
#include <sstream>

typedef struct Is_sensor {
    uint8_t gyro, mag, temp, accel;
} Is_sensor;

typedef struct Gps_info {
    std::string time, latitude, longitude, speed, course, date; 
    char        status, NS_indicator, EW_indicator, mode;
} Gps_info;

void init_sensors(GPS_I2C&, LSM9DS1&);
void read_imu(LSM9DS1&);
void is_available(Is_sensor&, LSM9DS1&);
void read_gps(GPS_I2C&, Gps_info&);
void search_word(char *sentences , char *one_sentence);
void RMC_parsing(char *rmc_sentence, Gps_info &rmc);


#endif