#include "GPS_I2C.h"

GPS_I2C::GPS_I2C(PinName sda, PinName scl, uint32_t freq)
    : _i2c(sda, scl), _freq(freq)
{
    _i2c.frequency(_freq);
}

GPS_I2C::~GPS_I2C() {}
/*****************************************************/
bool    GPS_I2C::begin()
{
    int ack;

    _head = 0;
    _tail = 0;

    ack = _i2c.read(MT333x_ADDR << 1, (char*)gpsData, 1);
    //Verify if module is connected
    if( ack != 0 ) return false;
    else           return true;
}

void    GPS_I2C::check()
{
    uint8_t packetData[MAX_PACKET_SIZE];

    for (uint8_t x = 0 ; x < MAX_PACKET_SIZE ; x++) {
        packetData[x] = 0x0A; //Fill with garbage byte
    }

    _i2c.read(MT333x_ADDR << 1, ((char*)packetData), MAX_PACKET_SIZE);

    for (uint8_t x = 0 ; x < MAX_PACKET_SIZE ; x++) {
        if (packetData[x] != 0x0A) {
            gpsData[_head++] = packetData[x];
            if (_head == MAX_PACKET_SIZE) _head = 0; //Wrap variable
        }
    }
}

uint8_t GPS_I2C::available()
{
    //If tail=head then no new data is available in the local buffer
    //So now check to see if the module has anything new in its buffer
    if (_tail == _head) {
        check(); //Check to module to see if new I2C bytes are available
    }

    //Return new data count
    if (_head > _tail) return (_head - _tail);
    if (_tail > _head) return (MAX_PACKET_SIZE - _tail + _head);
    return (0); //No data available
}
uint8_t GPS_I2C::read()
{
    if (_tail != _head) {
        uint8_t datum = gpsData[_tail++];
        if (_tail == MAX_PACKET_SIZE) _tail = 0; //Wrap variable
        return (datum);
    } else
        return (0); //No new data
}