#ifndef __GPSI2C__
#define __GPSI2C__

#include "mbed.h"
#include <string>

#define MT333x_ADDR 0x10 //7-bit unshifted default I2C Address

#define MAX_PACKET_SIZE 255
//If packet size is ever more than 255 the head and tail variables will need to be
//changed to something other than uint8_t

#define I2C_SPEED_STANDARD        100000
#define I2C_SPEED_FAST            400000

class GPS_I2C{
 public:
    //Constructor
    GPS_I2C(PinName sda, PinName scl, uint32_t freq); //Init I2C interface with Pin and frequency
    ~GPS_I2C();
    //Methods
    bool begin(); //Test if sensor is available
    void check();
    uint8_t available();
    uint8_t read(); 
    //Variables
    uint8_t gpsData[MAX_PACKET_SIZE]; //The place to store valid incoming gps data
    
 private:
    /*I2C config*/   
    I2C _i2c;
    uint32_t _freq;
    
    /*GPS buffer beginning/ending*/
    uint8_t _head;
    uint8_t _tail;
};

#endif