/* mbed TextOLED20x4 Library, for a 4-bit LCD based on HD44780
 * CopyLeft Rod Coleman 2012
 * Copyright (c) 2007-2010, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "TextOLED20x4.h"
#include "mbed.h"

TextOLED20x4::TextOLED20x4(PinName rs, PinName e, PinName d4, PinName d5,
                 PinName d6, PinName d7, LCDType type) : _rs(rs),
        _e(e), _d(d4, d5, d6, d7),
        _type(type) {

    _e  = 1;
    _rs = 0;            // command mode

 // Winstar 20x4 WH2004-NYG- needs 40ms after VDD> 4,5V
    /*
    wait(0.5);
    writeCommand(0x2); // 4-bit mode
    wait(0.05);
    writeCommand(0x28);    // Function set 001 BW N F - -
    wait(0.05);
    */
    //RC:2011-11-23: Newhaven 20x4 OLED data sheet method
    wait(0.33);
    writeCommand(0x2); // 4-bit mode
    wait(0.05);
    writeCommand(0x2); // 4-bit mode
    wait(0.05);
    writeCommand(0x28); // display OFF, "Function Set". 5x8 Font. UK/JP table. Newhaven say 0x08, but this loses 2 rows!
    wait(0.05); 
    writeCommand(0x1); // display clear. takes 6,2ms@fosc=250kHz
    wait(0.05);
    writeCommand(0x6); // entry mode set
    wait(0.05); 
    writeCommand(0x2); // 4-bit mode
    wait(0.05);                  
    writeCommand(0x0C); // ON-OFF ctrl: turns display ON, no cursor. Use 0x0E for cursor ON.
    /* 0x28 also works for Winstar WEH002004ALPP5N00000 OLED display. 0x29= westEuro fon table, 0x2A = UK/Russian
*/

    wait(0.015);        // Wait 15ms to ensure powered up
/*
    // send "Display Settings" 3 times (Only top nibble of 0x30 as we've got 4-bit bus)
    for (int i=0; i<3; i++) {
        writeByte(0x3);
        wait(0.00164);  // this command takes 1.64ms, so wait for it
    }
    writeByte(0x2);     // 4-bit mode
    wait(0.000040f);    // most instructions take 40us

    writeCommand(0x28); // Function set 001 BW N F - -
    writeCommand(0x0C);
    writeCommand(0x6);  // Cursor Direction and Display Shift : 0000 01 CD S (CD 0-left, 1-right S(hift) 0-no, 1-yes
    cls();*/
}

void TextOLED20x4::character(int column, int row, int c) {
    int a = address(column, row);
    writeCommand(a);
    writeData(c);
}

void TextOLED20x4::cls() {
    writeCommand(0x01); // cls, and set cursor to 0
    wait(0.00164f);     // This command takes 1.64 ms
    locate(0, 0);
}

void TextOLED20x4::locate(int column, int row) {
    _column = column;
    _row = row;
}

int TextOLED20x4::_putc(int value) {
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= rows()) {
            _row = 0;
        }
    } else {
        character(_column, _row, value);
        _column++;
        if (_column >= columns()) {
            _column = 0;
            _row++;
            if (_row >= rows()) {
                _row = 0;
            }
        }
    }
    return value;
}

int TextOLED20x4::_getc() {
    return -1;
}

void TextOLED20x4::writeByte(int value) {
    wait_us(1);
    _e = 1;          // RC added. Must go high at least 20ns after RS settled.
    _d = value >> 4;
    wait_us(1);
    _e = 0;
    wait_us(1);
    _d = value >> 0;
    _e = 1;
    wait_us(1);  // E high time is 250ns min, and low time 250ns min.
    _e = 0;
    wait_us(100);  // most instructions take 40us
    //_e = 1;
}

void TextOLED20x4::writeCommand(int command) {
    _e = 0;
    _rs = 0;
    writeByte(command);
}

void TextOLED20x4::writeData(int data) {
    _e = 0;
    _rs = 1;
    writeByte(data);
}

int TextOLED20x4::address(int column, int row) {
   /* switch (_type) {
        case LCD20x4:*/
            switch (row) {
                case 0:
                    return 0x80 + column;
                case 1:
                    return 0xc0 + column;
                case 2:
                    return 0x94 + column;
                case 3:
                    return 0xd4 + column;
            }
            return 0x80 + column;
            /*
        case LCD16x2B:
            return 0x80 + (row * 40) + column;
        case LCD16x2:
        case LCD20x2:
        default:
            return 0x80 + (row * 0x40) + column;
    }*/
}

int TextOLED20x4::columns() {
   return 20; 
    /* switch (_type) {
       case LCD20x4:
        case LCD20x2:
            return 20;
        case LCD16x2:
        case LCD16x2B:
        default:
            return 16;
    }*/
}

int TextOLED20x4::rows() {
    return 4;
    /*switch (_type) {
        case LCD20x4:
            return 4;
        case LCD16x2:
        case LCD16x2B:
        case LCD20x2:
        default:
            return 2;
    }*/
}
