#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "I2CTextLCD.h"

// EthernetNetIf eth;           // use this line if DHCP needed, or -
// /*
EthernetNetIf eth(
IpAddr(192,168,100,55), //IP Address  
IpAddr(255,255,255,0), //Network Mask  
IpAddr(192,168,100,1), //Gateway
IpAddr(192,168,1,254)  //DNS
);
// */
HTTPClient client;
I2CTextLCD lcd(p9, p10, 0x70); // sda scl, address
  
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut ConnectLED (LED2);
DigitalOut GetLED (LED4);
static const int ClientTimeoutMs = 28000; 
   
int main() {
pc.baud (115400);
lcd.cls();
wait(0.1);
lcd.locate(0,0);
lcd.printf("Setting up...");
EthernetErr ethErr = eth.setup();
if(ethErr)
  {
    lcd.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
lcd.locate(0,0);
lcd.printf("\r\nSetup OK\r\n");
HTTPText txt("text/html", 4096);
client.setTimeout(ClientTimeoutMs);
  for (int x = 10; x>0; x--) 
   {
     HTTPResult r = client.get("http://192.168.100.1/install/?page=installStatusData", &txt);
     GetLED = 1;
     lcd.printf("R:\"%s\"\n", txt.gets()); 
     lcd.printf("Error %d %4d\n", r, client.getHTTPResponseCode());
     wait (3);
   }
}
