/* mbed I2CTextLCD Library
 * Copyright (c) 2007-2009 sford
 * Copyright (c) 2010 Wim De Roeve  changed to work with I2C PCF8575
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef MBED_I2CTextLCD_H
#define MBED_I2CTextLCD_H

#include "mbed.h"
#include "Stream.h"

#define RS_ON         0x01   //PCF port P0
#define E1_ON         0x02   //PCF port P1 
#define E2_ON         0x40   //P6
#define BACKLIGHT_ON  0x80   //P7

/* Display ON/OFF Control defines */
#define DON                0x0F  //0b00001111  Display on 
#define DOFF               0x0B  //0b00001011  Display off 
#define CURSOR_ON          0x0F  //0b00001111  Cursor on 
#define CURSOR_OFF         0x0D  //0b00001101  Cursor off 
#define BLINK_ON           0x0F  //0b00001111  Cursor Blink 
#define BLINK_OFF          0x0E  //0b00001110  Cursor No Blink 

/* Cursor or Display Shift defines */
#define SHIFT_CUR_LEFT     0x13  //0b00010011  Cursor shifts to the left 
#define SHIFT_CUR_RIGHT    0x17  //0b00010111  Cursor shifts to the right 
#define SHIFT_DISP_LEFT    0x1B  //0b00011011  Display shifts to the left 
#define SHIFT_DISP_RIGHT   0x1F  //0b00011111  Display shifts to the right 

/* Function Set defines */
#define EIGHT_BITMODE      0x03  //0b00000011  8-bit Interface D4-D7
#define FOUR_BITMODE       0x02  //0b00000010  4-bit Interface D4-D7
#define LINE_5X7           0x30  //0b00110000
#define LINE_5X10          0x34  //0b00110100
#define LINES_5X7          0x38  //0b00111000

// Addtional define to support display mode

#define DISP_FLIP_NONE     0x00  //0b00111100  No flip
#define CLEAR_LCD          0x01  //0b00000001 

// Addtional define to support entry mode & shift mode
//#define ENTRY_CURSOR_DEC 0b00000101 /* Entry cursor move left */
//#define ENTRY_CURSOR_INC 0b00000111 /* Entry cursor move to right */
//#define ENTRY_DISPLAY_SHIFT 0b00000111 /* Entry the display to shift */
//#define ENTRY_DISPLAY_NO_SHIFT 0b00000110 /* Entry no shift */

// Use generic address

#define LINE0 0x80
#define LINE1 0xC0 
#define LINE2 0x94 
#define LINE3 0xD4 
namespace mbed {

/* Class: I2CTextLCD
 * A 16x2 Text LCD controller
 *
 * Allows you to print to a Text LCD screen, and locate/cls. Could be
 * turned in to a more generic libray.
 *
 * If you are connecting multiple displays, you can connect them all in
 * parallel, the address of the PCF8575 or PCF8574 must be unique for each
 * display.
 *
 * Example:
 * > #include "mbed.h"
 * > #include "I2CTextLCD.h"
 * >
 * > I2CTextLCD lcd(p9, P10, 0x40); // sda scl, address
 * >
 * > int main() {
 * >     lcd.printf("Hello World!");
 * > }
 */
class I2CTextLCD : public Stream {

public:
    /* Constructor: I2CTextLCD
     * Create a I2CTextLCD object
     *
     * wiring
     *
     * PCF8575/PCF8574  to  LCD..........Rods Fassung:
     * ----------------------
     * P0              -  D4.............RS
     * P1              -  D5..............E
     * P2              -  D6.............D4
     * P3              -  D7.............D5
     * P4              -  RS.............D6
     * P5              -  E1.............D7
     * P6              -  E2
     * P7              -  backlight (connected to a relay)
     * gnd             -  R/W
     *
     */
// I2C address for PCF8574AN [TI] is 0x38 for A0..2 = 000 0x39 for 001, NO it is 0x70.
// I2C slave addres for NXP PCF8574 = 0x 40 for A0..2 = 000 0x42 for 001
// I2C slave addres for NXP PCF8574A = 0x 70 for A0..2 = 000 0x72 for 001

    I2CTextLCD(PinName sda, PinName scl, int address, int columns = 20, int rows = 4, bool backlight = false);

#if 0 // Inhereted from Stream, for documentation only
    /* Function: putc
     *  Write a character
     *
     * Variables:
     *  c - The character to write to the serial port
     */
    int putc(int c);

    /* Function: printf
     *  Write a formated string
     *
     * Variables:
     *  format - A printf-style format string, followed by the
     *      variables to use in formating the string.
     */
    int printf(const char* format, ...);
#endif

    /* Function: locate
     * Locate to a certian position
     *
     * Variables:
     *  column - the column to locate to, from 0..15
     *  row - the row to locate to, from 0..1
     */
    virtual void locate(int column, int row);

    /* Function: cls
     * Clear the screen, and locate to 0,0
     */
    virtual void cls();

    virtual void reset();

    /* Function: backlight
    * Sets the backlight on or off
    *
    * Variables:
    *  on (true or false)
    */
    //virtual void backlight(bool on);

protected:

    void clock();
    void init8574A(void);
    void writeData(int data);
    void writeCommand(int command);
    void writeByte(int value, bool rs);
    //void writeNibble(int value, bool rs);
    // void writeI2CByte(int data);
    int readI2C();
    virtual int _putc(int c);
    virtual int _getc();
    virtual void newline();

    int _row;
    int _column;
    int _columns;
    int _rows;

    I2C _i2c;
    int _i2cAddress;
    bool _backlight;


private:



};

}

#endif

