/*  Copyright 2013 Rod Coleman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/   

#include "mbed.h"
 
#ifndef MBED_AD5258_H
#define MBED_AD5258_H
 
// Interface to the AD5258 I2C 64-step (0x00 to 0x3F)6-Bit digital Potentiometer

// measure reference voltage on the pin6 of U3 LM293
// be sure to remove R11, and check R4 is 220

/*Examples: RDAC =
0x00, Vref=1,0V
0x03, Vref=1,1V
0x05, Vref=1,2V
0x0F, Vref=1,5V
0x20, Vref=1,82V  // default
0x30, Vref=2,0V
0x3F, Vref=2,2V 
*/


class AD5258 {
public:
    /** Create an instance of the AD5258 connected to specfied I2C pins, with the specified address.
     *
     * @param sda The I2C data pin
     * @param scl The I2C clock pin
     * @param address The I2C address for this AD5258
     */
    AD5258(PinName sda, PinName scl, int address);
 
    /** Read the RDAC value
     *
     * @return The 6-bit value read
     */
    int read();
    
    /** Write to the RDAC
     * 
     * @param data The 6-bits value: 0x00 to 0x3F to write to the pots RDAC
     */
    void write(int data);
    
    // READ and WRITE EEPROM
    
        /** Read the EEPROM value
     *
     * @return The 6-bit value read
     */
    int readEE();
    
      /** Write to the RDAC
     * 
     * @param data The 6-bits value: 0x00 to 0x3F to write to the pots RDAC
     */
    void writeEE(int data); 
    
    
    
    
    // STORE and RESTORE:
    
    /** store the RDAC value into the EEPROM, for nonvolatile keeping of the value
    *
    */
    void store(void);
 
    /** restore to the RDAC the value from the EEPROM. NOP issued afterward, to put back into low-power idle mode
    *
    */
    void restore(void);
    
    
    /** update write protect bit
    *
    * @param enable: TRUE to SET WP, FALSE to lift WP
    */
 
    void writeProtect(bool enable);
 
    //  TODO: tolerance register access
 
 
 
private:
    I2C _i2c;
    int _address;
};
 
#endif