#include "AD5258.h"
#include "mbed.h"
 
AD5258::AD5258(PinName sda, PinName scl, int address)
        : _i2c(sda, scl) {
    _address = address;
}
 
 
 // RDAC ACCESS: values of 0 to 0x3F for full pot range.
 
int AD5258::read() {
    char foo[1];
    foo[0] = 00;                       // command to read RDAC
    _i2c.write(_address, foo, 1);  
    _i2c.read(_address, foo, 1);
    return foo[0];
}
 
void AD5258::write(int data) {
    char foo[2];
    foo[0] = 00;
    foo[1] = data;
    _i2c.write(_address, foo, 2);
}

// EEPROM ACCESS

int AD5258::readEE() {
    char foo[1];
    foo[0] = 0x20;                       // command to read RDAC
    _i2c.write(_address, foo, 1);  
    _i2c.read(_address, foo, 1);
    return foo[0];
}
 
void AD5258::writeEE(int data) {
    char foo[2];
    foo[0] = 0x20;
    foo[1] = data;
    _i2c.write(_address, foo, 2);
}
 
 // Store RDAC value to EEPROM, for nonvol retention:
 void AD5258::store(void)  {
    char foo[1];
    foo[0] = 0xC0;                       // command to store RDAC to EE
    _i2c.write(_address, foo, 1);      
 }
 
  // restore RDAC value from EEPROM
 void AD5258::restore(void)  {
    char foo[2];
    foo[0] = 0xA0;                       // command to store RDAC to EE
    foo[1] = 0x80;                       // NOP to restore low power mode
    _i2c.write(_address, foo, 1);      
  }
  
   // software write protect
 void AD5258::writeProtect(bool enable)  {
    char foo[2];
    foo[0] = 0x40;                       // command to store RDAC to EE
    if (enable) {
        foo[1] = 0x01;                       // SET WP
    }
    else {
        foo[1] = 0x010;                       // RESET WP (enable writes)
    }
    _i2c.write(_address, foo, 2);      
  }