#include "mbed.h"
 
#ifndef MBED_AD5258_H
#define MBED_AD5258_H
 
// Interface to the AD5258 I2C 6-Bit digital Potentiometer

class AD5258 {
public:
    /** Create an instance of the AD5258 connected to specfied I2C pins, with the specified address.
     *
     * @param sda The I2C data pin
     * @param scl The I2C clock pin
     * @param address The I2C address for this AD5258
     */
    AD5258(PinName sda, PinName scl, int address);
 
    /** Read the RDAC value
     *
     * @return The 6-bit value read
     */
    int read();
    
    /** Write to the RDAC
     * 
     * @param data The 6-bits value: 0x00 to 0x3F to write to the pots RDAC
     */
    void write(int data);
    
    // READ and WRITE EEPROM
    
        /** Read the EEPROM value
     *
     * @return The 6-bit value read
     */
    int readEE();
    
      /** Write to the RDAC
     * 
     * @param data The 6-bits value: 0x00 to 0x3F to write to the pots RDAC
     */
    void writeEE(int data); 
    
    
    
    
    // STORE and RESTORE:
    
    /** store the RDAC value into the EEPROM, for nonvolatile keeping of the value
    *
    */
    void store(void);
 
    /** restore to the RDAC the value from the EEPROM. NOP issued afterward, to put back into low-power idle mode
    *
    */
    void restore(void);
 
 
private:
    I2C _i2c;
    int _address;
};
 
#endif